% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPvalplot}
\alias{CGGPvalplot}
\title{Plot validation prediction errors for CGGP object}
\usage{
CGGPvalplot(CGGP, Xval, Yval, d = NULL)
}
\arguments{
\item{CGGP}{CGGP object that has been fitted}

\item{Xval}{X validation data}

\item{Yval}{Y validation data}

\item{d}{If output is multivariate, which column to use. Will do all if
left as NULL.}
}
\value{
None, makes a plot
}
\description{
Plot validation prediction errors for CGGP object
}
\examples{
SG <- CGGPcreate(d=3, batchsize=100)
f1 <- function(x){x[1]+x[2]^2}
y <- apply(SG$design, 1, f1)
SG <- CGGPfit(SG, y)
Xval <- matrix(runif(3*100), ncol=3)
Yval <- apply(Xval, 1, f1)
CGGPvalplot(CGGP=SG, Xval=Xval, Yval=Yval)
}
\seealso{
Other CGGP plot functions: 
\code{\link{CGGPplotblocks}()},
\code{\link{CGGPplotcorr}()},
\code{\link{CGGPplotheat}()},
\code{\link{CGGPplothist}()},
\code{\link{CGGPplotsamplesneglogpost}()},
\code{\link{CGGPplotslice}()},
\code{\link{CGGPplottheta}()},
\code{\link{CGGPplotvariogram}()}
}
\concept{CGGP plot functions}
