% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFformat.R
\name{CFtimestamp}
\alias{CFtimestamp}
\title{Create a vector of character strings that represent CF timestamps}
\usage{
CFtimestamp(cf, format = "date")
}
\arguments{
\item{cf}{CFtime. The \code{CFtime} instance that contains the offsets to use.}

\item{format}{character. An atomic string with either of the values "date",
"time", "timestamp".}
}
\value{
A character vector where each element represents a moment in time
according to the \code{format} specifier. Time zone information is not represented.
}
\description{
The \code{CFtime} instance contains a vector of offsets from an origin. This
function generates a vector of character strings that represent the date
and/or time in a selectable combination for each offset.
}
\details{
The character strings use the format \verb{YYYY-MM-DDThh:mm:ss±hh:mm}, depending
on the \code{format} specifier. The date in the string is not necessarily
compatible with \code{POSIXt} - in the \verb{360_day} calendar \code{2017-02-30} is valid
and \code{2017-03-31} is not.
}
\examples{
cf <- CFtime("hours since 2020-01-01", "standard", seq(0, 24, by = 0.25))
CFtimestamp(cf, "timestamp")
}
