% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brStick.R
\name{brStick}
\alias{brStick}
\title{Broken-stick method for detection of significant factors}
\usage{
brStick(eigs)
}
\arguments{
\item{eigs}{numeric. Vector of eigenvalues}
}
\value{
Returns the number of significant factors.
}
\description{
This function provides a simple way to determine the number of significant
factors in a factor analysis. This is done by comparing the eigenvalues of
each factor with those expected from a broken-stick distribution.
}
\examples{
mod1 <- enfa(x = climdat.hist, s.dat = ABPR, field = "CODE")
brStick(s.factor(mod1))

}
\references{
Jackson, Donald A. "Stopping rules in principal components analysis:
  a comparison of heuristical and statistical approaches." Ecology 74.8 (1993):
  2204-2214.
}
