% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim2opt.R
\name{optim2Opt}
\alias{optim2Opt}
\title{Two-Opt}
\usage{
optim2Opt(x = NULL, fun, control = list())
}
\arguments{
\item{x}{start solution of the local search}

\item{fun}{function that determines cost or length of a route/permutation}

\item{control}{(list), with the options:
\describe{
\item{\code{archive}}{ Whether to keep all candidate solutions and their fitness in an archive (TRUE) or not (FALSE). Default is TRUE.}
\item{\code{budget}}{ The limit on number of target function evaluations (stopping criterion) (default: 100)}
\item{\code{creationFunction}}{ Function to create individuals/solutions in search space. Default is a function that creates random permutations of length 6}
\item{\code{vectorized}}{ Boolean. Defines whether target function is vectorized (takes a list of solutions 
as argument) or not (takes single solution as argument). Default: FALSE}
}}
}
\value{
a list with:
\describe{
\item{\code{xbest}}{ best solution found}
\item{\code{ybest}}{ fitness of the best solution}
\item{\code{count}}{ number of performed target function evaluations }
}
}
\description{
Implementation of a Two-Opt local search.
}
\examples{
seed=0
#distance
dF <- distancePermutationHamming
#creation
cF <- function()sample(5)
#objective function
lF <- landscapeGeneratorUNI(1:5,dF)
#start optimization
set.seed(seed)
res <- optim2Opt(,lF,list(creationFunction=cF,budget=100,
   vectorized=TRUE)) ##target function is "vectorized", expects list of solutions as input
res

}
\references{
Wikipedia contributors. "2-opt." Wikipedia, The Free Encyclopedia. Wikipedia, The Free Encyclopedia, 13 Jun. 2014. Web. 21 Oct. 2014. (http://en.wikipedia.org/wiki/2-opt)
}
\seealso{
\code{\link{optimCEGO}}, \code{\link{optimEA}}, \code{\link{optimRS}}, \code{\link{optimMaxMinDist}}
}
