% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEDA.R
\name{medianNormalization}
\alias{medianNormalization}
\title{Median normalization of sgRNA counts}
\usage{
medianNormalization(data, control)
}
\arguments{
\item{data}{A numeric matrix containing raw read counts of sgRNAs
with rows corresponding to sgRNAs and columns correspondings to samples.}

\item{control}{A numeric matrix containing raw read counts of negative 
control sgRNAs with rows corresponding to sgRNAs and columns 
corresponding to samples. Sample ordering is the same as in data.}
}
\value{
A list with two elements: 1) size factors of all samples; 
  2) normalized counts of sgRNAs.
}
\description{
This function adjusts sgRNA counts by the median ratio method.
The normalized sgRNA read counts are calculated as the raw read counts 
devided by a size factor. The size factor is calcuated as the median of 
all size factors caculated from negative control sgRNAs (eg., sgRNAs 
corresponding to non-targeting or non-essential genes).
}
\examples{
count <- matrix(rnbinom(5000 * 6, mu=500, size=3), ncol = 6)
colnames(count) = paste0("sample", 1:6)
rownames(count) = paste0("sgRNA", 1:5000)
control <- count[1:100,]
normalizedcount <- medianNormalization(count, control)

}
