% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdmSubset.R
\name{cdmSubset}
\alias{cdmSubset}
\title{Subset a cdm object to a set of persons}
\usage{
cdmSubset(cdm, personId)
}
\arguments{
\item{cdm}{A cdm_reference object}

\item{personId}{A numeric vector of person IDs to include in the cdm}
}
\value{
A modified cdm_reference object where all clinical tables are lazy
queries pointing to subset
}
\description{
\code{cdmSubset} takes a cdm object and a list of person IDs as input. It
returns a new cdm that includes data only for persons matching the provided
person IDs. Generated cohorts in the cdm will also be subset to
the IDs provided.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(CDMConnector)
library(dplyr, warn.conflicts = FALSE)

con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())

cdm <- cdm_from_con(con, cdm_schema = "main")

cdm2 <- cdmSubset(cdm, personId = c(2, 18, 42))

cdm2$person \%>\%
  select(1:3)
#> # Source:   SQL [3 x 3]
#> # Database: DuckDB 0.6.1
#>   person_id gender_concept_id year_of_birth
#>       <dbl>             <dbl>         <dbl>
#> 1         2              8532          1920
#> 2        18              8532          1965
#> 3        42              8532          1909

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
