% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{getMaxError}
\alias{getMaxError}
\title{Determine an approximate CDF's maximum error.}
\usage{
getMaxError(Y, est, ...)
}
\arguments{
\item{Y}{The vector output of a non-differentially private CDF 
computation (cumulative count bins)}

\item{est}{The vector output of a differentially private CDF 
computation (cumulative count bins)}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
A single value, the largest absolute vertical difference between 
   parallel observations in the private- and true-CDF vectors.
}
\description{
Find the maximum direct error between a non-private CDF and a 
   DP approximation of that CDF.
}
\examples{
getMaxError(c(.1,.2,.3,.4,.5,.6,.7,.8,.9,1), c(.1,.2,.3,.3,.3,.3,.3,.3,.4,1))
}

