% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doEvaluation.R
\name{doEvaluation}
\alias{doEvaluation}
\title{Evaluate Different Weighting Factors}
\usage{
doEvaluation(DF, p = 0.05, userWeights = NULL)
}
\arguments{
\item{DF}{data frame, it must contain a column named 'Concentration' and a column named 'Response'}

\item{p}{p-value, default is 0.05}

\item{userWeights}{user defined weights in linear regression, default is NULL. User can easily define weights, e.g., "1/x", "1/x^2", "1/y"}
}
\value{
dataframe, weighting factor evaluation result
}
\description{
Evaluate different weighting factors.
}
\examples{
Concentration <- rep(c(10, 50, 100, 500), each = 3)
Response <- c(133, 156, 177, 1300, 1450, 1600, 4000, 3881, 3700, 140000, 139000, 140000)
DF <- cbind.data.frame(Concentration = Concentration, Response = Response)
result <- doEvaluation(DF)
}
\author{
Yonghui Dong
}
