% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_RefGrid.R
\name{add_RefGrid}
\alias{add_RefGrid}
\title{Add a Reference grid}
\usage{
add_RefGrid(
  bb,
  ResLat = 1,
  ResLon = 2,
  LabLon = NA,
  lwd = 1,
  fontsize = 1,
  offset = NA
)
}
\arguments{
\item{bb}{bounding box of the first plotted object. for example, \code{bb=bbox(SmallBathy)} or \code{bb=bbox(MyPolys)}.}

\item{ResLat}{Latitude resolution in decimal degrees.}

\item{ResLon}{Longitude resolution in decimal degrees.}

\item{LabLon}{Longitude at which Latitude labels should appear. if set, the resulting Reference grid will be circumpolar.}

\item{lwd}{Line thickness of the Reference grid.}

\item{fontsize}{Font size of the Reference grid's labels.}

\item{offset}{offset of the Reference grid's labels (distance to plot border).}
}
\description{
Add a Latitude/Longitude reference grid to maps.
}
\examples{

#Example 1: Circumpolar grid with Latitude labels at Longitude 0

Mypar=par(mai=c(1,1.5,0.5,0)) #Figure margins as c(bottom, left, top, right)
par(Mypar)
plot(SmallBathy,breaks=Depth_cuts, col=Depth_cols, legend=FALSE,axes=FALSE,box=FALSE)
add_RefGrid(bb=bbox(SmallBathy),ResLat=10,ResLon=20,LabLon = 0)

#Example 2: Local grid around created polygons

MyPolys=create_Polys(PolyData,Densify=TRUE)
BathyC=raster::crop(SmallBathy,MyPolys) #crop the bathymetry to match the extent of MyPolys
Mypar=par(mai=c(0.5,0.5,0.5,0.5)) #Figure margins as c(bottom, left, top, right)
par(Mypar)
plot(BathyC,breaks=Depth_cuts, col=Depth_cols, legend=FALSE,axes=FALSE,box=FALSE)
add_RefGrid(bb=bbox(BathyC),ResLat=2,ResLon=6)
plot(MyPolys,add=TRUE,col='orange',border='brown',lwd=2)

}
\seealso{
\code{\link{SmallBathy}}
}
