% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\docType{class}
\name{CASMAP-class}
\alias{CASMAP-class}
\alias{CASMAP}
\title{Constructor for CASMAP class object.}
\description{
Constructor for CASMAP class object.
}
\details{
Constructor for CASMAP class object, which needs the \code{mode}
parameter to be set by the user. Please see the examples.
}
\section{Fields}{

\describe{
\item{\code{mode}}{Either \code{'regionGWAS'} or \code{'higherOrderEpistasis'}.}

\item{\code{alpha}}{A numeric value setting the Family-wise Error Rate (FWER).
Must be strictly between \code{0} and \code{1}. Default
value is \code{0.05}.}

\item{\code{max_comb_size}}{A numeric specifying the maximum length of 
combinations. For example, if set to \code{4}, 
then only combinations of size between \code{1}
and \code{4} (inclusive) will be considered.
To consider combinations of arbitrary (maximal)
length, use value \code{0}, which is the default 
value.}
}}


\section{Base method, for both modes}{

\describe{
  \item{\code{readFiles}}{Read the data, label and possibly covariates 
                         files. Parameters are \code{genotype_file}, 
                         for the data, \code{phenotype_file} for the
                         labels and (optional) \code{covariates_file}
                         for the covariates. The option 
                         \code{plink_file_root} is not supported
                         in the current version, but will be supported
                         in future versions.}

  \item{\code{setMode}}{Can set/change the mode, but note that any
                       data files will need to read in again using
                       the \code{readFiles} command.}

  \item{\code{setTargetFWER}}{Can set/change the Family-wise 
                             Error Rate (FWER). Takes a numeric
                             parameter \code{alpha}, strictly between
                             \code{0} and \code{1}.}
  
  \item{\code{execute}}{Once the data files have been read, can execute the
                       algorithm. Please note that, depending on the size
                       of the data files, this could take a long time.}
  
  \item{\code{getSummary}}{Returns a data frame with a summary of the 
                          results from the execution, but not any
                          significant regions/itemsets. See 
                          \code{getSignificantRegions}, 
                          \code{getSignificantInteractions}, and
                          \code{getSignificantClusterRepresentatives}. }
  
  \item{\code{writeSummary}}{Directly write the information
                             from \code{getSummary} to file.}
  
}
}

\section{\code{regionGWAS} Methods}{

\describe{
  \item{\code{getSignificantRegions}}{Returns a data frame with the 
                          the significant regions. Only valid when
                          \code{mode='regionGWAS'}.}
  
  \item{\code{getSignificantClusterRepresentatives}}{Returns a data 
                          frame with the 
                          the representatives of the significant 
                          clusters. This will be a subset of the regions
                          returned from \code{getSignificantRegions}. 
                          Only valid when \code{mode='regionGWAS'}.}
  
  \item{\code{writeSignificantRegions}}{Writes the data from 
                          \code{getSignificantRegions} to file, which
                          must be specified in the parameter 
                          \code{path}.
                          Only valid when \code{mode='regionGWAS'}.}
  
  \item{\code{writeSignificantClusterRepresentatives}}{Writes the data 
                          from 
                          \code{getSignificantClusterRepresentatives} to 
                          file, which must be specified in the parameter 
                          \code{path}.
                          Only valid when \code{mode='regionGWAS'}.}
  
   }
}

\section{\code{higherOrderEpistasis} Methods}{

\describe{
  \item{\code{getSignificantInteractions}}{Returns the frame 
                          from \code{getSignificantInteractions} to 
                          file, which must be specified in the parameter 
                          \code{path}. Only valid 
                          when \code{mode='higherOrderEpistasis'}.}
  
  \item{\code{writeSignificantInteractions}}{Writes a data frame with  
                          the significant interactions. Only valid 
                          when \code{mode='higherOrderEpistasis'}.}
  
   }
}

\section{References}{

A. Terada, M. Okada-Hatakeyama, K. Tsuda and J. Sese
 \emph{Statistical significance of combinatorial regulations},
 Proceedings of the National Academy of Sciences (2013) 110 
 (32): 12996-13001

F. Llinares-Lopez, D. G. Grimm, D. Bodenham,
U. Gieraths, M. Sugiyama, B. Rowan and K. Borgwardt,
\emph{Genome-wide detection of intervals of genetic heterogeneity 
      associated with complex traits},
ISMB 2015, Bioinformatics (2015) 31 (12): i240-i249

L. Papaxanthos, F. Llinares-Lopez, D. Bodenham,
K .Borgwardt,
\emph{Finding significant combinations of features in the 
 presence of categorical covariates}, Advances
 in Neural Information Processing Systems 29 (NIPS 2016), 2271-2279.

F. Llinares-Lopez, L. Papaxanthos, D. Bodenham,
D. Roqueiro and K .Borgwardt,
\emph{Genome-wide genetic heterogeneity discovery 
 with categorical covariates}.
Bioinformatics 2017, 33 (12): 1820-1828.
}

\examples{

## An example using the "regionGWAS" mode
fastcmh <- CASMAP(mode="regionGWAS")      # initialise object

datafile <- getExampleDataFilename()      # file name of example data
labelsfile <- getExampleLabelsFilename()  # file name of example labels
covfile <- getExampleCovariatesFilename() # file name of example covariates 

# read the data, labels and covariate files
fastcmh$readFiles(genotype_file=getExampleDataFilename(),
                  phenotype_file=getExampleLabelsFilename(), 
                  covariate_file=getExampleCovariatesFilename() )

# execute the algorithm (this may take some time)
fastcmh$execute()

#get the summary results
summary_results <- fastcmh$getSummary()

#get the significant regions
sig_regions <- fastcmh$getSignificantRegions()

#get the clustered representatives for the significant regions
sig_cluster_rep <- fastcmh$getSignificantClusterRepresentatives()


## Another example of regionGWAS
fais <- CASMAP(mode="regionGWAS")      # initialise object

# read the data and labels, but no covariates
fastcmh$readFiles(genotype_file=getExampleDataFilename(),
                  phenotype_file=getExampleLabelsFilename())


## Another example, doing higher order epistasis search
facs <- CASMAP(mode="higherOrderEpistasis")      # initialise object

}
