/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class LinearRegression
extends DataPlotDialog {
    private String modelString;
    private JPanel analysisOptsPane;
    public JRadioButton binomDistButton;
    private JCheckBox browserResults;
    private JCheckBox confIntervals;
    private JLabel confLabel;
    private JSpinner confLevelSpinner;
    private JCheckBox cookDist;
    private JComboBox dependentComboBox;
    private JLabel dependentLabel;
    private ButtonGroup distButtonGroup;
    private JPanel distPane;
    private JLabel independentLabel;
    private JList independentList;
    private JScrollPane independentScrollPane;
    private JCheckBox influencePlot;
    private JPanel modelEqPane;
    private JScrollPane modelEqScrollPane;
    private JTextArea modelEqTextArea;
    public JRadioButton normDistButton;
    private JCheckBox normalQQ;
    private JPanel plotOptsPane;
    private JPanel plotPane;
    public JRadioButton poisDistButton;
    private JCheckBox resVsFit;
    private JLabel resultLabel;
    private JTextField resultName;
    private JCheckBox rmIntercept;
    private JComboBox sampleSizeComboBox;
    private JLabel sampleSizeLabel;
    private JPanel savePanel;
    private JCheckBox saveResults;
    private JCheckBox scaleLoc;
    private JPanel varPane;

    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinearRegression.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    public void refreshDistValidity() {
        Enumeration<AbstractButton> distButtonEnum = this.distButtonGroup.getElements();
        while (distButtonEnum.hasMoreElements()) {
            distButtonEnum.nextElement().setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0);
        }
    }

    public void refreshModelValidity() {
        this.refreshDistValidity();
        this.refreshVariableListValidity();
    }

    public void updateModelEquation() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            String modelEq = this.dependentComboBox.getSelectedItem() + " ~ " + RUtils.toString(this.independentList.getSelectedValues(), " + ", "");
            this.modelEqTextArea.setText(modelEq);
            if (this.binomDistButton.isSelected()) {
                this.setModelString(this.sampleSizeComboBox.getSelectedItem() + "," + this.dependentComboBox.getSelectedItem() + "," + RUtils.toString(this.independentList.getSelectedValues(), ",", ""));
            } else {
                this.setModelString(modelEq);
            }
        } else {
            this.setModelString(null);
            this.modelEqTextArea.setText(null);
        }
    }

    public void refreshVariableListValidity() {
        this.dependentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.dependentComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.independentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.independentList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.sampleSizeLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.sampleSizeComboBox.getItemCount() > 0 && this.binomDistButton.isSelected());
        this.sampleSizeComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.sampleSizeComboBox.getItemCount() > 0 && this.binomDistButton.isSelected());
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
            Vector<String> onePlusNonFactors = new Vector<String>(nonFactors.size() + 1);
            onePlusNonFactors.add("1");
            onePlusNonFactors.addAll(nonFactors);
            this.dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.independentList.setListData(RUtils.colnamesVector(this.getDatasetPane().getSelectedDataset()));
            this.sampleSizeComboBox.setModel(new DefaultComboBoxModel(onePlusNonFactors));
            if (this.dependentComboBox.getItemCount() > 0) {
                this.dependentComboBox.setSelectedIndex(0);
            }
            if (this.sampleSizeComboBox.getItemCount() > 0) {
                this.sampleSizeComboBox.setSelectedIndex(0);
            }
        } else {
            this.dependentComboBox.removeAllItems();
            this.independentList.setModel(new DefaultListModel());
            this.sampleSizeComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    public void refreshConfLevelValidity() {
        this.confLabel.setEnabled(this.confIntervals.isSelected());
        this.confLevelSpinner.setEnabled(this.confIntervals.isSelected());
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(!this.independentList.isSelectionEmpty());
    }

    public void refreshValidity() {
        this.refreshModelValidity();
        this.refreshConfLevelValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.distButtonGroup = new ButtonGroup();
        this.plotPane = new JPanel();
        this.distPane = new JPanel();
        this.normDistButton = new JRadioButton();
        this.poisDistButton = new JRadioButton();
        this.binomDistButton = new JRadioButton();
        this.modelEqPane = new JPanel();
        this.modelEqScrollPane = new JScrollPane();
        this.modelEqTextArea = new JTextArea();
        this.varPane = new JPanel();
        this.dependentLabel = new JLabel();
        this.dependentComboBox = new JComboBox();
        this.independentLabel = new JLabel();
        this.independentScrollPane = new JScrollPane();
        this.independentList = new JList();
        this.sampleSizeLabel = new JLabel();
        this.sampleSizeComboBox = new JComboBox();
        this.plotOptsPane = new JPanel();
        this.resVsFit = new JCheckBox();
        this.normalQQ = new JCheckBox();
        this.scaleLoc = new JCheckBox();
        this.cookDist = new JCheckBox();
        this.influencePlot = new JCheckBox();
        this.analysisOptsPane = new JPanel();
        this.rmIntercept = new JCheckBox();
        this.confIntervals = new JCheckBox();
        this.confLabel = new JLabel();
        this.confLevelSpinner = new JSpinner();
        this.savePanel = new JPanel();
        this.saveResults = new JCheckBox();
        this.resultLabel = new JLabel();
        this.resultName = new JTextField();
        this.browserResults = new JCheckBox();
        this.distPane.setBorder(BorderFactory.createTitledBorder("Distribution"));
        this.distButtonGroup.add(this.normDistButton);
        this.normDistButton.setSelected(true);
        this.normDistButton.setText("Normal");
        this.normDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.normDistButton.setMargin(new Insets(0, 0, 0, 0));
        this.distButtonGroup.add(this.poisDistButton);
        this.poisDistButton.setText("Poisson");
        this.poisDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.poisDistButton.setMargin(new Insets(0, 0, 0, 0));
        this.distButtonGroup.add(this.binomDistButton);
        this.binomDistButton.setText("Binomial");
        this.binomDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.binomDistButton.setMargin(new Insets(0, 0, 0, 0));
        this.binomDistButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                LinearRegression.this.binomDistButtonStateChanged(evt);
            }
        });
        GroupLayout distPaneLayout = new GroupLayout((Container)this.distPane);
        this.distPane.setLayout((LayoutManager)distPaneLayout);
        distPaneLayout.setHorizontalGroup((GroupLayout.Group)distPaneLayout.createParallelGroup(1).add((GroupLayout.Group)distPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.normDistButton).add(18, 18, 18).add((Component)this.poisDistButton).add(18, 18, 18).add((Component)this.binomDistButton).addContainerGap(42, Short.MAX_VALUE)));
        distPaneLayout.setVerticalGroup((GroupLayout.Group)distPaneLayout.createParallelGroup(1).add((GroupLayout.Group)distPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)distPaneLayout.createParallelGroup(3).add((Component)this.normDistButton).add((Component)this.poisDistButton).add((Component)this.binomDistButton)).addContainerGap(16, Short.MAX_VALUE)));
        this.modelEqPane.setBorder(BorderFactory.createTitledBorder("Model Equation"));
        this.modelEqTextArea.setColumns(20);
        this.modelEqTextArea.setEditable(false);
        this.modelEqTextArea.setLineWrap(true);
        this.modelEqTextArea.setRows(2);
        this.modelEqTextArea.setWrapStyleWord(true);
        this.modelEqScrollPane.setViewportView(this.modelEqTextArea);
        GroupLayout modelEqPaneLayout = new GroupLayout((Container)this.modelEqPane);
        this.modelEqPane.setLayout((LayoutManager)modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup((GroupLayout.Group)modelEqPaneLayout.createParallelGroup(1).add((GroupLayout.Group)modelEqPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqScrollPane, -1, 565, Short.MAX_VALUE).addContainerGap()));
        modelEqPaneLayout.setVerticalGroup((GroupLayout.Group)modelEqPaneLayout.createParallelGroup(1).add((GroupLayout.Group)modelEqPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqScrollPane, -2, -1, -2).addContainerGap(13, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.dependentLabel.setText("Dependent:");
        this.dependentComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LinearRegression.this.dependentComboBoxActionPerformed(evt);
            }
        });
        this.independentLabel.setText("Independent:");
        this.independentList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                LinearRegression.this.independentListValueChanged(evt);
            }
        });
        this.independentScrollPane.setViewportView(this.independentList);
        this.sampleSizeLabel.setText("Sample Size:");
        GroupLayout varPaneLayout = new GroupLayout((Container)this.varPane);
        this.varPane.setLayout((LayoutManager)varPaneLayout);
        varPaneLayout.setHorizontalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(2).add((Component)this.sampleSizeLabel).add((Component)this.independentLabel).add((Component)this.dependentLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.independentScrollPane, -1, 196, Short.MAX_VALUE).add(2, (Component)this.sampleSizeComboBox, 0, 196, Short.MAX_VALUE).add(2, (Component)this.dependentComboBox, 0, 196, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.dependentComboBox, -2, -1, -2).add((Component)this.dependentLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.independentLabel).add((Component)this.independentScrollPane, -1, 230, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.sampleSizeComboBox, -2, -1, -2).add((Component)this.sampleSizeLabel)).addContainerGap()));
        this.plotOptsPane.setBorder(BorderFactory.createTitledBorder("Diagnostic Plots"));
        this.resVsFit.setText("Residual vs. Fitted");
        this.normalQQ.setText("Normal Q-Q Plot");
        this.scaleLoc.setText("Scale-Location Plot");
        this.cookDist.setText("Cook's Distance Plot");
        this.influencePlot.setText("Influence Plot");
        GroupLayout plotOptsPaneLayout = new GroupLayout((Container)this.plotOptsPane);
        this.plotOptsPane.setLayout((LayoutManager)plotOptsPaneLayout);
        plotOptsPaneLayout.setHorizontalGroup((GroupLayout.Group)plotOptsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptsPaneLayout.createSequentialGroup().add((GroupLayout.Group)plotOptsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.resVsFit, -2, 154, -2)).add((GroupLayout.Group)plotOptsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.normalQQ, -2, 154, -2)).add((GroupLayout.Group)plotOptsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.scaleLoc, -2, 154, -2)).add((GroupLayout.Group)plotOptsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.cookDist)).add((GroupLayout.Group)plotOptsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.influencePlot, -2, 154, -2))).addContainerGap(121, Short.MAX_VALUE)));
        plotOptsPaneLayout.setVerticalGroup((GroupLayout.Group)plotOptsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.resVsFit).addPreferredGap(0).add((Component)this.normalQQ).addPreferredGap(0).add((Component)this.scaleLoc).addPreferredGap(0).add((Component)this.cookDist).addPreferredGap(0).add((Component)this.influencePlot).addContainerGap(-1, Short.MAX_VALUE)));
        this.analysisOptsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.rmIntercept.setText("Remove Intercept");
        this.confIntervals.setText("Compute Confidence Intervals");
        this.confIntervals.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                LinearRegression.this.confIntervalsStateChanged(evt);
            }
        });
        this.confLabel.setText("Confidence Level:");
        this.confLevelSpinner.setModel(new SpinnerNumberModel(0.95, 0.01, 0.99, 0.01));
        GroupLayout analysisOptsPaneLayout = new GroupLayout((Container)this.analysisOptsPane);
        this.analysisOptsPane.setLayout((LayoutManager)analysisOptsPaneLayout);
        analysisOptsPaneLayout.setHorizontalGroup((GroupLayout.Group)analysisOptsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)analysisOptsPaneLayout.createParallelGroup(1).add((Component)this.rmIntercept).add((GroupLayout.Group)analysisOptsPaneLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.confLabel).addPreferredGap(0).add((Component)this.confLevelSpinner, -2, -1, -2)).add((Component)this.confIntervals)).addContainerGap(104, Short.MAX_VALUE)));
        analysisOptsPaneLayout.setVerticalGroup((GroupLayout.Group)analysisOptsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.rmIntercept).addPreferredGap(0).add((Component)this.confIntervals).addPreferredGap(0).add((GroupLayout.Group)analysisOptsPaneLayout.createParallelGroup(3).add((Component)this.confLabel).add((Component)this.confLevelSpinner, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.saveResults.setText("Save R Results?");
        this.saveResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveResults.setMargin(new Insets(0, 0, 0, 0));
        this.saveResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LinearRegression.this.saveResultsActionPerformed(evt);
            }
        });
        this.resultLabel.setText("R Result Name");
        this.resultLabel.setEnabled(false);
        this.resultName.setColumns(12);
        this.resultName.setEnabled(false);
        this.browserResults.setText("Display Results in Browser");
        this.browserResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserResults.setMargin(new Insets(0, 0, 0, 0));
        this.browserResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LinearRegression.this.browserResultsActionPerformed(evt);
            }
        });
        GroupLayout savePanelLayout = new GroupLayout((Container)this.savePanel);
        this.savePanel.setLayout((LayoutManager)savePanelLayout);
        savePanelLayout.setHorizontalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((Component)this.browserResults).add((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().add((Component)this.saveResults).addPreferredGap(0, 166, -2)).add(2, (GroupLayout.Group)savePanelLayout.createSequentialGroup().addPreferredGap(0, 41, -2).add((Component)this.resultLabel).add(10, 10, 10).add((Component)this.resultName, -2, 140, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        savePanelLayout.setVerticalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().add((Component)this.browserResults).addPreferredGap(0).add((Component)this.saveResults).addPreferredGap(0).add((GroupLayout.Group)savePanelLayout.createParallelGroup(3).add((Component)this.resultLabel).add((Component)this.resultName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout((Container)this.plotPane);
        this.plotPane.setLayout((LayoutManager)plotPaneLayout);
        plotPaneLayout.setHorizontalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(2, false).add(1, (Component)this.modelEqPane, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.varPane, -1, -1, Short.MAX_VALUE).add((Component)this.distPane, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((Component)this.savePanel, -1, -1, Short.MAX_VALUE).add((Component)this.analysisOptsPane, -1, -1, Short.MAX_VALUE).add((Component)this.plotOptsPane, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        plotPaneLayout.setVerticalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.plotOptsPane, -2, -1, -2).addPreferredGap(0).add((Component)this.analysisOptsPane, -2, -1, -2).addPreferredGap(0).add((Component)this.savePanel, -2, -1, -2)).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.distPane, -2, -1, -2).addPreferredGap(0).add((Component)this.varPane, -1, -1, Short.MAX_VALUE))).addContainerGap(52, Short.MAX_VALUE)));
        this.setTitle("Linear Regression");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 640) / 2, (screenSize.height - 675) / 2, 640, 675);
    }

    private void confIntervalsStateChanged(ChangeEvent evt) {
        this.refreshValidity();
    }

    private void binomDistButtonStateChanged(ChangeEvent evt) {
        this.sampleSizeLabel.setEnabled(this.binomDistButton.isSelected());
        this.sampleSizeComboBox.setEnabled(this.binomDistButton.isSelected());
        this.updateModelEquation();
    }

    private void dependentComboBoxActionPerformed(ActionEvent evt) {
        this.updateModelEquation();
    }

    private void independentListValueChanged(ListSelectionEvent evt) {
        this.updateModelEquation();
        this.refreshSubmitButtonValidity();
    }

    private void saveResultsActionPerformed(ActionEvent evt) {
        this.resultLabel.setEnabled(this.saveResults.isSelected());
        this.resultName.setEnabled(this.saveResults.isSelected());
        if (this.saveResults.isSelected()) {
            this.resultName.setText("my.glm.fit");
        } else {
            this.resultName.setText(null);
        }
    }

    private void browserResultsActionPerformed(ActionEvent evt) {
    }

    protected void submitButtonAction() {
        String distfamily = null;
        if (this.normDistButton.isSelected()) {
            distfamily = "gaussian";
        } else if (this.poisDistButton.isSelected()) {
            distfamily = "poisson";
        } else if (this.binomDistButton.isSelected()) {
            distfamily = "binomial";
        }
        String cmd = "glm.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", my.formula=" + "'" + this.getModelString() + "'" + ", my.family=" + "'" + distfamily + "'" + ", iCI=" + String.valueOf(this.confIntervals.isSelected()).toUpperCase() + (this.confIntervals.isSelected() ? ", conf.level=" + (Double)this.confLevelSpinner.getValue() : "") + ", iDiag.1=" + String.valueOf(this.resVsFit.isSelected()).toUpperCase() + ", iDiag.2=" + String.valueOf(this.normalQQ.isSelected()).toUpperCase() + ", iDiag.3=" + String.valueOf(this.scaleLoc.isSelected()).toUpperCase() + ", iDiag.4=" + String.valueOf(this.cookDist.isSelected()).toUpperCase() + ", iInfluence=" + String.valueOf(this.influencePlot.isSelected()).toUpperCase() + ", iRmIntercept=" + String.valueOf(this.rmIntercept.isSelected()).toUpperCase() + ", saveLMName=" + "'" + this.resultName.getText() + "'" + ", browserResults=" + String.valueOf(this.browserResults.isSelected()).toUpperCase() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void helpButtonAction() {
        String cmd = "CADStat.help('glm.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    public String getModelString() {
        return this.modelString;
    }

    public void setModelString(String modelString) {
        this.modelString = modelString;
    }
}

