% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-coef.R
\docType{methods}
\name{S4BuyseTest-coef}
\alias{S4BuyseTest-coef}
\alias{coef,S4BuyseTest-method}
\title{Extract Summary Statistics from GPC}
\usage{
\S4method{coef}{S4BuyseTest}(
  object,
  endpoint = NULL,
  statistic = NULL,
  strata = FALSE,
  cumulative = NULL,
  resampling = FALSE,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{S4BuyseTest} object, output of \code{\link{BuyseTest}}.}

\item{endpoint}{[character] for which endpoint(s) the summary statistic should be output?
If \code{NULL} returns the summary statistic for all endpoints.}

\item{statistic}{[character] the type of summary statistic. See the detail section.}

\item{strata}{[character vector] the strata relative to which the statistic should be output.
Can also be \code{"global"} or \code{FALSE} to output the statistic pooled over all strata,
or \code{TRUE} to output each strata-specific statistic.}

\item{cumulative}{[logical] should the summary statistic be cumulated over endpoints?
Otherwise display the contribution of each endpoint.}

\item{resampling}{[logical] should the summary statistic obtained by resampling be output?}

\item{simplify}{[logical] should the result be coerced to the lowest possible dimension?}

\item{...}{ignored.}
}
\value{
When \code{resampling=FALSE} and \code{simplify=FALSE}, a matrix (strata, endpoint).
When \code{resampling=FALSE} and \code{simplify=FALSE}, an array (sample, strata, endpoint).
}
\description{
Extract summary statistics (net benefit, win ratio, ...) from GPC.
}
\details{
One of the following statistic can be specified:
\itemize{
\item \code{"netBenefit"}: returns the net benefit.
\item \code{"winRatio"}: returns the win ratio.
\item \code{"favorable"}: returns the proportion in favor of the treatment (also called Mann-Whitney parameter).
\item \code{"unfavorable"}: returns the proportion in favor of the control.
\item \code{"unfavorable"}: returns the proportion of neutral pairs.
\item \code{"unfavorable"}: returns the proportion of uninformative pairs.
\item \code{"count.favorable"}: returns the number of pairs in favor of the treatment.
\item \code{"count.unfavorable"}: returns the number of pairs in favor of the control.
\item \code{"count.neutral"}: returns the number of neutral pairs.
\item \code{"count.uninf"}: returns the number of uninformative pairs.
}
}
\author{
Brice Ozenne
}
\keyword{method}
