% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-coef.R
\docType{methods}
\name{S4BuyseTest-coef}
\alias{S4BuyseTest-coef}
\alias{coef,S4BuyseTest-method}
\title{Coef Method for Class "S4BuyseTest"}
\usage{
\S4method{coef}{S4BuyseTest}(
  object,
  endpoint = NULL,
  statistic = NULL,
  stratified = FALSE,
  cumulative = NULL,
  resampling = FALSE,
  ...
)
}
\arguments{
\item{object}{output of \code{\link{BuyseTest}}}

\item{endpoint}{[character] for which endpoint(s) the summary statistic should be output?
If \code{NULL} returns the summary statistic for all endpoints.}

\item{statistic}{[character] the type of summary statistic. See the detail section.}

\item{stratified}{[logical] should the summary statistic be strata-specific?
Otherwise a summary statistic over all strata is returned.}

\item{cumulative}{[logical] should the summary statistic be cumulated over endpoints?
Otherwise display the contribution of each endpoint.}

\item{resampling}{[logical] should the summary statistic obtained by resampling be output?}

\item{...}{ignored.}
}
\value{
When \code{resampling=FALSE} and \code{stratified=FALSE}, return a numeric vector.
When \code{resampling=FALSE} and \code{stratified=TRUE}, return a matrix.
When \code{resampling=TRUE} and \code{stratified=FALSE}, return a matrix.
When \code{resampling=TRUE} and \code{stratified=TRUE}, return an 3-dimensional array.
}
\description{
Extract summary statistics from the result of a \code{\link{BuyseTest}} function.
}
\details{
One of the following statistic can be specified:
\itemize{
\item \code{"netBenefit"}: returns the net benefit.
\item \code{"winRatio"}: returns the win ratio.
\item \code{"favorable"}: returns the proportion in favor of the treatment (also called Mann-Whitney parameter).
\item \code{"unfavorable"}: returns the proportion in favor of the control.
\item \code{"unfavorable"}: returns the proportion of neutral pairs.
\item \code{"unfavorable"}: returns the proportion of uninformative pairs.
\item \code{"count.favorable"}: returns the number of pairs in favor of the treatment.
\item \code{"count.unfavorable"}: returns the number of pairs in favor of the control.
\item \code{"count.neutral"}: returns the number of neutral pairs.
\item \code{"count.uninf"}: returns the number of uninformative pairs.
}
}
\author{
Brice Ozenne
}
\keyword{S4BuyseTest-method}
\keyword{coef}
