% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importData.R
\name{simHapMap}
\alias{simHapMap}
\title{Generate a data.frame with a hapmap data in it to test phasedHapMap2mat}
\usage{
simHapMap(nInd = 200, nMrk = 1050, nChr = 7, lenChr = 150,
  maf = stats::runif(nMrk), nCharCode = 2, nQTL = NULL,
  propDomi = NULL, interactionMean = NULL, varEffects = NULL)
}
\arguments{
\item{nInd}{The number of individuals with marker data}

\item{nMrk}{The number of markers}

\item{nChr}{The number of chromosomes the species has}

\item{lenChr}{The length of the chromosomes (all equal) in cM}

\item{maf}{The desired minor allele frequency of each marker}

\item{nCharCode}{Whether the genotype codes should be one or two characters}

\item{nQTL}{If you want to put QTL information in the hapmap}

\item{propDomi}{proportion of QTL that act dominantly}

\item{interactionMean}{average number of loci interacting with QTL: Poisson}

\item{varEffects}{variance of the QTL effects}
}
\value{
A data.frame with hapmap data in it
}
\description{
Generate a data.frame with a hapmap data in it to test phasedHapMap2mat
}
