% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLM.R
\name{extractAIC.BranchGLM}
\alias{extractAIC.BranchGLM}
\title{Extract AIC from BranchGLM Objects}
\usage{
\method{extractAIC}{BranchGLM}(fit, scale, k = 2, ...)
}
\arguments{
\item{fit}{a \code{BranchGLM} object.}

\item{scale}{ignored.}

\item{k}{a non-negative number specifying the ‘weight’ of the equivalent degrees
of freedom (= edf) part in the AIC formula.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A numeric vector of length 2, with first and second elements giving
\item{\code{edf}}{ the ‘equivalent degrees of freedom’ for \code{fit}}
\item{\code{AIC}}{ the (generalized) Akaike Information Criterion for \code{fit}}
}
\description{
Computes the (generalized) Akaike An Information Criterion for
BranchGLM objects.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")
extractAIC(Fit)

}
