% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{table_predictors}
\alias{table_predictors}
\title{Table model predictor performance}
\usage{
table_predictors(df, model, predictors)
}
\arguments{
\item{df}{data.frame containing the data set. If evaluating independently, use the test set.}

\item{model}{statistical model to be evaluated.}

\item{predictors}{vector of characters designating columns of interest. Non-specified independent variables will not be included.}
}
\value{
data.frame with coefficients and p-values for predictor variables
}
\description{
Extract coefficients and p-values only for regression models and table them
}
\examples{
data <- survival::lung
mod <- build_reg_model(data, 'age', 'sex')
tbl <- table_predictors(data, mod, 'sex')

}
\author{
J. Peter Marquardt
}
