% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gff_plot.R
\name{gff_to_loc}
\alias{gff_to_loc}
\title{gff_to_loc}
\usage{
gff_to_loc(gff_data, mRNA_ID = NULL)
}
\arguments{
\item{gff_data}{gff file.}

\item{mRNA_ID}{The mRNA you selected. If NULL, it means selecting all mRNAs.}
}
\value{
list
}
\description{
Extract the location information of element from gff or gtf file
}
\examples{

gff_path <- system.file("extdata", "test.gff", package = "BioVizSeq")
gff_data <- read.table(gff_path, header = FALSE, sep = '\t')
gff_loc <- gff_to_loc(gff_data)

ID_path <- system.file("extdata", "ID_select.csv", package = "BioVizSeq")
mRNA_ID <- readLines(ID_path) 
gff_loc <- gff_to_loc(gff_data, mRNA_ID=mRNA_ID)
}
\author{
Shiqi Zhao
}
