% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARSupportFunctions.R
\name{VARXLagCons}
\alias{VARXLagCons}
\title{Construct a VAR or VARX lag matrix}
\usage{
VARXLagCons(Y, X = NULL, p, s = 0, oos = FALSE, contemp = FALSE)
}
\arguments{
\item{Y}{a \eqn{T \times k} matrix of endogenous (modeled) series}

\item{X}{a \eqn{T \times m} matrix of exogenous (unmodeled) series (default NULL)}

\item{p}{Endogenous Lag order}

\item{s}{exogenous lag order (default zero)}

\item{oos}{indicator as to whether the data should be constructed for out of sample prediction (i.e. last available entries of Y as final lags default FALSE)}

\item{contemp}{indicator as to whether to use contemporaneous exogenous predictors (for example, if exogenous series become available before exogenous default FALSE).}
}
\value{
list with two entries:
\itemize{
\item{"Z"}{\eqn{kp+ms+1\times T-max(p,s)} VARX lag matrix}
\item{"Y"}{adjusted \eqn{k\times T-max(p,s)} endogenous series}
}
}
\description{
Construct a VAR or VARX lag matrix
}
\details{
This function is not required unless you which to design your own cross validation routine.
}
\examples{
data(Y)
# construct VAR lag matrix with p=4
ZZ<-VARXLagCons(Y,X=NULL,p=4,s=0)
}
\references{
See page 15 of Lutkepohl, "A New Introduction to Multiple Time Series Analysis
}
\seealso{
\code{\link{MultVarSim}}
}
