% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmult_vector.R
\name{bdblockmult_vector}
\alias{bdblockmult_vector}
\title{Block matrix-vector multiplication with Delayed Array Object}
\usage{
bdblockmult_vector(
  A,
  b,
  block_size = 128,
  paral = TRUE,
  threads = NULL,
  outfile = "tmp_blockmult_vector.hdf5",
  onmemory = FALSE
)
}
\arguments{
\item{A}{a double matrix.}

\item{b}{a double vector or array.}

\item{block_size}{(optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)}

\item{paral, }{(optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation}

\item{threads}{(optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available}

\item{outfile}{(optional) file name to work with hdf5 if we are working with big matrix in disk.}

\item{onmemory}{(optional) if onmemory = TRUE the multiplication is forced to execute in memory}
}
\value{
numerical matrix
}
\description{
This function performs a block matrix-vector multiplication with R-Objects or Delayed Arrays
}
\examples{
# with numeric matrix

library(DelayedArray)

k <- 100
n <- 400
A <- matrix(rnorm(n*k), nrow=n, ncol=k)
B <- sample(1:100,50, replace = TRUE);

res <- bdblockmult_vector(A, B, 128, TRUE)


}
