% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphhelpfns.R
\name{compareDAGs}
\alias{compareDAGs}
\title{Comparing two DAGs}
\usage{
compareDAGs(eDAG, trueDAG)
}
\arguments{
\item{eDAG}{an object of class \code{\link[graph]{graphNEL}} (package `graph'), representing the DAG which should be compared to a ground truth DAG}

\item{trueDAG}{an object of class \code{\link[graph]{graphNEL}} (package `graph'), representing the ground truth DAG}
}
\value{
a vector of 3: SHD, number of true positive edges and number of false positive edges
}
\description{
This function compares one (estimated) DAG to another DAG (true DAG), returning a vector of 3 values: structural Hamming distance,
number of true positive edges and number of false positive edges.
}
\examples{
myDAG<-pcalg::randomDAG(20, prob=0.15, lB = 0.4, uB = 2)
myData<-pcalg::rmvDAG(200, myDAG) 
myScore<-scoreparameters(20,"bge",myData)
\dontrun{
eDAG<-orderMCMC(20,myScore)
compareDAGs(adjacency2dag(eDAG$max$DAG),myDAG)
}
}
