% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_betapower.R
\name{plot_betapower}
\alias{plot_betapower}
\title{Plots of Beta power}
\usage{
plot_betapower(betapower.matrix,link.type,by)
}
\arguments{
\item{betapower.matrix}{a matrix obtained by the function betapower.(the formula was described as the output formula in the function betapower)}

\item{link.type}{the type of link used in the beta regression. You can choose one or more of the following: "logit", "probit", "cloglog", "cauchit", "log", "loglog", "all"}

\item{by}{the type of plot. see details.}
}
\description{
Generate several comparison plots of power.
}
\details{
plot_betapower() returns different plots depends on by\cr
by = "linktype": plot_betapower() returns graphs that plot power against mu1, 
where mu1 is the mean for the treatment group under the alternative. 
The number of plots will vary depending on the number of link types selected with the last plot showing power based on Wilcoxon Rank Sum Test.
The first one or several plots show comparisons of power with different sample size, using GLM method with one or several link types. 
The last plot shows a comparison of the power with different sample size using Wilcoxon Rank Sum Test. 
Y-axis denotes power and X-axis denotes mu1, the mean for the treatment group under the alternative.\cr
by = "samplesize": plot_betapower() returns a number of plots equal to the number of sample sizes tested. 
Each plot compares power calculated with different link types and the Wilcoxon Rank Sum Test.
Y-axis denotes power and X-axis denotes mu1, the mean for the treatment group under the alternative.\cr
by = "mu1": plot_betapower() returns a number of plots equal to the number of mu1 used in the procedure. 
Each plot compares power calculated with different link types and the Wilcoxon Rank Sum Test.
Y-axis denotes power and X-axis denotes sample size.\cr
}
\examples{
## generate the power table with betapower
BPmat <- betapower(mu0 = 0.56, sd0 = 0.255, mu1.start = .70, mu1.end = .80, mu1.by = .10, 
ss.start = 30, ss.end = 50, ss.by = 20, trials = 15, link.type = c("logit","log"))
## plot by link types
plot_betapower(BPmat,link.type = c("logit","log"),by="linktype")
## plot by sample size
plot_betapower(BPmat,link.type = c("logit","log"),by="samplesize")
}
