% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infection_to_death.R
\name{itd_distribution}
\alias{itd_distribution}
\title{Distribution of the time between infection and death}
\usage{
itd_distribution(
  ts_length,
  gamma_mean = 24.19231,
  gamma_cv = 0.3987261,
  gamma_shape = 6.29,
  gamma_rate = 0.26
)
}
\arguments{
\item{ts_length}{integer;
time from infection to death in days.}

\item{gamma_mean}{numeric;
mean of a gamma distribution, for a given shape and rate. See also \code{\link[stats]{GammaDist}}.}

\item{gamma_cv}{numeric;
coefficient of variation of a gamma distribution, for a given shape and rate. See also \code{\link[stats]{GammaDist}}.}

\item{gamma_shape}{numeric;
shape parameter of a gamma distribution. See also \code{\link[stats]{GammaDist}}.}

\item{gamma_rate}{numeric;
rate parameter of a gamma distribution. See also \code{\link[stats]{GammaDist}}.}
}
\value{
A vector of length \emph{ts_length}.
}
\description{
Function to discretize the infection-to-death distribution
}
\examples{
# Age-specific mortality/incidence count time series:
data(age_specific_mortality_counts)

# Infection-to-death distribution:
ditd <- itd_distribution(ts_length  = nrow(age_specific_mortality_counts),
                         gamma_mean = 24.19231,
                         gamma_cv   = 0.3987261)

}
\references{
Flaxman et al (2020). Estimating the effects of non-pharmaceutical interventions on COVID-19 in Europe.
Nature, 584, 257-261.
}
