% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBeeGUTS.R
\name{plot.beeSurvPred}
\alias{plot.beeSurvPred}
\title{Plotting method for \code{beeSurvPred} objects}
\usage{
\method{plot}{beeSurvPred}(
  x,
  ...,
  xlab = "Time [d]",
  ylab1 = "Survival probability",
  ylab2 = "Concentration",
  main = paste("Predictions results for a BeeGUTS", x$modelType, "calibrated for",
    x$beeSpecies)
)
}
\arguments{
\item{x}{An object of class \code{beeSurvPred}}

\item{...}{Additional parameters to generic plot functions (not used)}

\item{xlab}{A character string for the label of the x-axis}

\item{ylab1}{A character string for the label of the y-axis of the survivor plots}

\item{ylab2}{A character string for the label of the y-axis of the concentration plots}

\item{main}{A character string for the title label plot}
}
\value{
A graphic with results of the forward prediction
}
\description{
This is the generic \code{plot} S3 method for the \code{beeSurvPred}
class. It plots the predicted number of survivors for the exposure concentration entered by the user.
}
\examples{
\donttest{
dataPredict <- data.frame(time = c(1:10, 1:10, 1:10),
                     conc = c(rep(5, 10), rep(10, 10), rep(15, 10)),
                     replicate = c(rep("rep1", 10), rep("rep2", 10), rep("rep3", 10)),
                     NSurv = c(rep(5, 10), rep(10, 10), rep(15, 10)))
data(fitBetacyfluthrin_Chronic)
prediction <- predict(fitBetacyfluthrin_Chronic, dataPredict)
plot(prediction)
}
}
