/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MultivariateFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class GeneralizedLinearModel
extends AbstractModelLikelihood
implements MultivariateFunction {
    protected Parameter dependentParam;
    protected List<Parameter> independentParam;
    protected List<Parameter> indParamDelta;
    protected List<DesignMatrix> designMatrix;
    protected int[] scaleDesign;
    protected Parameter scaleParameter;
    protected int numIndependentVariables = 0;
    protected int numRandomEffects = 0;
    protected int N;
    protected List<Parameter> randomEffects = null;

    public GeneralizedLinearModel(Parameter parameter) {
        super("glmModel");
        this.dependentParam = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
            this.N = parameter.getDimension();
        } else {
            this.N = 0;
        }
    }

    public int[] getScaleDesign() {
        return this.scaleDesign;
    }

    public void addRandomEffectsParameter(Parameter parameter) {
        if (this.randomEffects == null) {
            this.randomEffects = new ArrayList<Parameter>();
        }
        if (this.N != 0 && parameter.getDimension() != this.N) {
            throw new RuntimeException("Random effects have the wrong dimension");
        }
        this.addVariable(parameter);
        this.randomEffects.add(parameter);
        ++this.numRandomEffects;
        if (this.N == 0) {
            this.N = parameter.getDimension();
        }
    }

    public void addIndependentParameter(Parameter parameter, DesignMatrix designMatrix, Parameter parameter2) {
        if (this.designMatrix == null) {
            this.designMatrix = new ArrayList<DesignMatrix>();
        }
        if (this.independentParam == null) {
            this.independentParam = new ArrayList<Parameter>();
        }
        if (this.indParamDelta == null) {
            this.indParamDelta = new ArrayList<Parameter>();
        }
        if (this.N == 0) {
            this.N = designMatrix.getRowDimension();
        }
        this.designMatrix.add(designMatrix);
        this.independentParam.add(parameter);
        this.indParamDelta.add(parameter2);
        if (this.designMatrix.size() != this.independentParam.size()) {
            throw new RuntimeException("Independent variables and their design matrices are out of sync");
        }
        this.addVariable(parameter);
        this.addVariable(designMatrix);
        if (parameter2 != null) {
            this.addVariable(parameter2);
        }
        ++this.numIndependentVariables;
        Logger.getLogger("dr.inference").info("\tAdding independent predictors '" + parameter.getStatisticName() + "' with design matrix '" + designMatrix.getStatisticName() + "'");
    }

    public boolean getAllIndependentVariablesIdentifiable() {
        SingularValueDecomposition singularValueDecomposition;
        int n;
        int n2;
        int n3 = 0;
        for (DesignMatrix designMatrix : this.designMatrix) {
            n3 += designMatrix.getColumnDimension();
        }
        Object object = new double[this.N][n3];
        int n4 = 0;
        for (DesignMatrix designMatrix : this.designMatrix) {
            n2 = designMatrix.getColumnDimension();
            for (n = 0; n < this.N; n += 1) {
                for (int i = 0; i < n2; ++i) {
                    object[n][n4 + i] = designMatrix.getParameterValue(n, i);
                }
            }
            n4 += n2;
        }
        Object object2 = object;
        if (((Object)object).length < ((Object)object[0]).length) {
            object2 = new double[((Object)object[0]).length][((Object)object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                for (n2 = 0; n2 < ((Object)object[i]).length; ++n2) {
                    object2[n2][i] = object[i][n2];
                }
            }
        }
        n = n3 == (n2 = (singularValueDecomposition = new SingularValueDecomposition(new DenseDoubleMatrix2D((double[][])object2))).rank()) ? 1 : 0;
        Logger.getLogger("dr.inference").info("\tTotal # of predictors = " + n3 + " and rank = " + n2);
        if (!n) {
            Logger.getLogger("dr.inference").info("\tProvided matrix of independent variables is not identifiable.");
        }
        return n != 0;
    }

    public int getNumberOfFixedEffects() {
        return this.numIndependentVariables;
    }

    public int getNumberOfRandomEffects() {
        return this.numRandomEffects;
    }

    public double[] getXBeta() {
        Parameter parameter;
        int n;
        double[] dArray = new double[this.N];
        for (n = 0; n < this.numIndependentVariables; ++n) {
            parameter = this.independentParam.get(n);
            Parameter parameter2 = this.indParamDelta.get(n);
            DesignMatrix designMatrix = this.designMatrix.get(n);
            int n2 = parameter.getDimension();
            for (int i = 0; i < n2; ++i) {
                double d = parameter.getParameterValue(i);
                if (parameter2 != null) {
                    d *= parameter2.getParameterValue(i);
                }
                for (int j = 0; j < this.N; ++j) {
                    int n3 = j;
                    dArray[n3] = dArray[n3] + designMatrix.getParameterValue(j, i) * d;
                }
            }
        }
        for (n = 0; n < this.numRandomEffects; ++n) {
            parameter = this.randomEffects.get(n);
            for (int i = 0; i < this.N; ++i) {
                int n4 = i;
                dArray[n4] = dArray[n4] + parameter.getParameterValue(i);
            }
        }
        return dArray;
    }

    public Parameter getFixedEffect(int n) {
        return this.independentParam.get(n);
    }

    public Parameter getFixedEffectIndicator(int n) {
        return this.indParamDelta.get(n);
    }

    public Parameter getRandomEffect(int n) {
        return this.randomEffects.get(n);
    }

    public Parameter getDependentVariable() {
        return this.dependentParam;
    }

    public double[] getXBeta(int n) {
        double[] dArray = new double[this.N];
        Parameter parameter = this.independentParam.get(n);
        Parameter parameter2 = this.indParamDelta.get(n);
        DesignMatrix designMatrix = this.designMatrix.get(n);
        int n2 = parameter.getDimension();
        for (int i = 0; i < n2; ++i) {
            double d = parameter.getParameterValue(i);
            if (parameter2 != null) {
                d *= parameter2.getParameterValue(i);
            }
            for (int j = 0; j < this.N; ++j) {
                int n3 = j;
                dArray[n3] = dArray[n3] + designMatrix.getParameterValue(j, i) * d;
            }
        }
        if (this.numRandomEffects != 0) {
            throw new RuntimeException("Attempting to retrieve fixed effects without controlling for random effects");
        }
        return dArray;
    }

    public int getEffectNumber(Parameter parameter) {
        return this.independentParam.indexOf(parameter);
    }

    public double[][] getX(int n) {
        return this.designMatrix.get(n).getParameterAsMatrix();
    }

    public DesignMatrix getDesignMatrix(int n) {
        return this.designMatrix.get(n);
    }

    public double[] getScale() {
        double[] dArray = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            dArray[i] = this.scaleParameter.getParameterValue(this.scaleDesign[i]);
        }
        return dArray;
    }

    public double[][] getScaleAsMatrix() {
        throw new RuntimeException("Not yet implemented: GeneralizedLinearModel.getScaleAsMatrix()");
    }

    protected abstract double calculateLogLikelihood(double[] var1);

    protected abstract double calculateLogLikelihood();

    protected abstract boolean confirmIndependentParameters();

    public abstract boolean requiresScale();

    public void addScaleParameter(Parameter parameter, Parameter parameter2) {
        this.scaleParameter = parameter;
        this.scaleDesign = new int[parameter2.getDimension()];
        for (int i = 0; i < this.scaleDesign.length; ++i) {
            this.scaleDesign[i] = (int)parameter2.getParameterValue(i);
        }
        this.addVariable(parameter);
    }

    @Override
    public double evaluate(double[] dArray) {
        return this.calculateLogLikelihood(dArray);
    }

    @Override
    public int getNumArguments() {
        int n = 0;
        for (Parameter parameter : this.independentParam) {
            n += parameter.getDimension();
        }
        return n;
    }

    @Override
    public double getLowerBound(int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 > this.independentParam.get(n3).getDimension()) {
            n2 -= this.independentParam.get(n3).getDimension();
            ++n3;
        }
        return this.independentParam.get(n3).getBounds().getLowerLimit(n2);
    }

    @Override
    public double getUpperBound(int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 > this.independentParam.get(n3).getDimension()) {
            n2 -= this.independentParam.get(n3).getDimension();
            ++n3;
        }
        return this.independentParam.get(n3).getBounds().getUpperLimit(n2);
    }

    public abstract GeneralizedLinearModel factory(List<Parameter> var1, List<Parameter> var2);

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        return this.calculateLogLikelihood();
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getLogLikelihood();
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.N];
        for (int i = 0; i < this.N; ++i) {
            logColumnArray[i] = new NumberArrayColumn(this.getId() + i, i);
        }
        return logColumnArray;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    private class NumberArrayColumn
    extends NumberColumn {
        private final int index;

        public NumberArrayColumn(String string, int n) {
            super(string);
            this.index = n;
        }

        @Override
        public double getDoubleValue() {
            return GeneralizedLinearModel.this.getXBeta()[this.index];
        }
    }
}

