/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;

public class NNI
extends AbstractTreeOperator {
    private TreeModel tree = null;

    public NNI(TreeModel treeModel, double d) {
        this.tree = treeModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        double d;
        NodeRef nodeRef;
        int n = this.tree.getNodeCount();
        NodeRef nodeRef2 = this.tree.getRoot();
        while (nodeRef2 == (nodeRef = this.tree.getNode(MathUtils.nextInt(n))) || this.tree.getParent(nodeRef) == nodeRef2) {
        }
        NodeRef nodeRef3 = this.tree.getParent(nodeRef);
        NodeRef nodeRef4 = this.tree.getParent(nodeRef3);
        NodeRef nodeRef5 = this.tree.getChild(nodeRef4, 0);
        if (nodeRef5 == nodeRef3) {
            nodeRef5 = this.tree.getChild(nodeRef4, 1);
        }
        double d2 = this.tree.getNodeHeight(nodeRef4);
        double d3 = this.tree.getNodeHeight(nodeRef5);
        double d4 = Math.max(d3, this.tree.getNodeHeight(this.getOtherChild(this.tree, nodeRef3, nodeRef)));
        double d5 = this.tree.getNodeHeight(nodeRef);
        double d6 = Math.max(d5, this.tree.getNodeHeight(this.getOtherChild(this.tree, nodeRef3, nodeRef)));
        while ((d = MathUtils.nextDouble()) == 0.0 || d == 1.0) {
        }
        double d7 = d4 + d * (d2 - d4);
        this.tree.setNodeHeight(nodeRef3, d7);
        double d8 = Math.log((d2 - d4) / (d2 - d6));
        this.exchangeNodes(this.tree, nodeRef, nodeRef5, nodeRef3, nodeRef4);
        this.tree.pushTreeChangedEvent(nodeRef3);
        this.tree.pushTreeChangedEvent(nodeRef4);
        return d8;
    }

    @Override
    public String getOperatorName() {
        return "NearestNeighborInterchange";
    }

    public double getMinimumAcceptanceLevel() {
        return 0.025;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.05;
    }

    public String getPerformanceSuggestion() {
        return null;
    }
}

