/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import java.util.Iterator;
import java.util.List;

public class SimpleSiteList
implements SiteList {
    private final TaxonList taxonList;
    private final DataType dataType;
    private int siteCount = 0;
    private int[][] sitePatterns = new int[0][];
    protected String id = null;

    public SimpleSiteList(DataType dataType) {
        this.taxonList = null;
        this.dataType = dataType;
    }

    public SimpleSiteList(DataType dataType, TaxonList taxonList) {
        this.taxonList = taxonList;
        this.dataType = dataType;
    }

    public int addPattern(int[] nArray) {
        int n = this.sitePatterns.length;
        if (this.siteCount >= n) {
            int[][] nArrayArray = new int[n += 10000][];
            for (int i = 0; i < this.siteCount; ++i) {
                nArrayArray[i] = this.sitePatterns[i];
            }
            this.sitePatterns = nArrayArray;
        }
        this.sitePatterns[this.siteCount] = nArray;
        ++this.siteCount;
        return this.siteCount - 1;
    }

    @Override
    public int getSiteCount() {
        return this.siteCount;
    }

    @Override
    public int[] getSitePattern(int n) {
        return this.sitePatterns[n];
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        throw new UnsupportedOperationException("getUncertainSitePattern not implemented yet");
    }

    @Override
    public int getPatternIndex(int n) {
        return n;
    }

    @Override
    public int getState(int n, int n2) {
        return this.getSitePattern(n2)[n];
    }

    @Override
    public double[] getUncertainState(int n, int n2) {
        throw new UnsupportedOperationException("getUncertainState not implemented yet");
    }

    @Override
    public int getPatternCount() {
        return this.getSiteCount();
    }

    @Override
    public int getStateCount() {
        return this.dataType.getStateCount();
    }

    @Override
    public int getPatternLength() {
        return this.getTaxonCount();
    }

    @Override
    public int[] getPattern(int n) {
        return this.getSitePattern(n);
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("getUncertainPattern not implemented yet");
    }

    @Override
    public int getPatternState(int n, int n2) {
        return this.getSitePattern(n2)[n];
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        throw new UnsupportedOperationException("getUncertainPatternState not implemented yet");
    }

    @Override
    public double getPatternWeight(int n) {
        return 1.0;
    }

    @Override
    public double[] getPatternWeights() {
        double[] dArray = new double[this.getSiteCount()];
        for (int i = 0; i < this.getSiteCount(); ++i) {
            dArray[i] = 1.0;
        }
        return dArray;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public double[] getStateFrequencies() {
        return PatternList.Utils.empiricalStateFrequencies(this);
    }

    @Override
    public boolean areUnique() {
        return false;
    }

    @Override
    public boolean areUncertain() {
        return false;
    }

    @Override
    public int getTaxonCount() {
        if (this.taxonList == null) {
            throw new RuntimeException("SimpleSiteList has no taxonList");
        }
        return this.taxonList.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        if (this.taxonList == null) {
            throw new RuntimeException("SimpleSiteList has no taxonList");
        }
        return this.taxonList.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        if (this.taxonList == null) {
            throw new RuntimeException("SimpleSiteList has no taxonList");
        }
        return this.taxonList.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        if (this.taxonList == null) {
            throw new RuntimeException("SimpleSiteList has no taxonList");
        }
        return this.taxonList.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        if (this.taxonList == null) {
            throw new RuntimeException("SimpleSiteList has no taxonList");
        }
        return this.taxonList.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        if (this.taxonList == null) {
            throw new RuntimeException("SimpleSiteList has no taxonList");
        }
        return this.taxonList.asList();
    }

    @Override
    public Iterator<Taxon> iterator() {
        if (this.taxonList == null) {
            throw new RuntimeException("SimpleSiteList has no taxonList");
        }
        return this.taxonList.iterator();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (this.taxonList == null) {
            throw new RuntimeException("SimpleSiteList has no taxonList");
        }
        return this.taxonList.getTaxonAttribute(n, string);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }
}

