% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcDREAMzs.R
\name{DREAMzs}
\alias{DREAMzs}
\title{DREAMzs}
\usage{
DREAMzs(bayesianSetup, settings = list(iterations = 10000, nCR = 3, gamma
  = NULL, eps = 0, e = 0.05, pCRupdate = FALSE, updateInterval = 10, burnin
  = 0, thin = 1, adaptation = 0.2, parallel = NULL, Z = NULL,
  ZupdateFrequency = 10, pSnooker = 0.1, DEpairs = 2, consoleUpdates = 10,
  startValue = NULL, currentChain = 1, message = FALSE))
}
\arguments{
\item{bayesianSetup}{Object of class 'bayesianSetup' or 'bayesianOuput'.}

\item{settings}{list with parameter values}

\item{iterations}{Number of model evaluations}

\item{nCR}{parameter determining the number of cross-over proposals.  If nCR = 1 all parameters are updated jointly.}

\item{updateInterval}{determining the intervall for the pCR (crossover probabilities) update}

\item{gamma}{Kurtosis parameter Bayesian Inference Scheme.}

\item{eps}{Ergodicity term}

\item{e}{Ergodicity term}

\item{pCRupdate}{Update of crossover probabilities}

\item{burnin}{number of iterations treated as burn-in. These iterations are not recorded in the chain.}

\item{thin}{thin thinning parameter. Determines the interval in which values are recorded.}

\item{adaptation}{Number or percentage of samples that are used for the adaptation in DREAM (see Details)}

\item{DEpairs}{Number of pairs used to generate proposal}

\item{ZupdateFrequency}{frequency to update Z matrix}

\item{pSnooker}{probability of snooker update}

\item{Z}{starting matrix for Z}

\item{startValue}{eiter a matrix containing the start values (see details), an integer to define the number of chains that are run, a function to sample the start values or NUll, in which case the values are sampled from the prior.}

\item{consoleUpdates}{Intervall in which the sampling progress is printed to the console}

\item{message}{logical determines whether the sampler's progress should be printed}
}
\value{
mcmc.object containing the following elements: chains, X, pCR, Z
}
\description{
DREAMzs
}
\details{
Insted of a bayesianSetup, the function can take the output of a previous run to restart the sampler 
from the last iteration. Due to the sampler's internal structure you can only use the output
of DREAMzs.
If you provide a matrix with start values the number of rows detemines the number of chains that are run.
The number of coloumns must be equivalent to the number of parameters in your bayesianSetup. \cr\cr
There are several small differences in the algorithm presented here compared to the original paper by Vrugt et al. (2009). Mainly
the algorithm implemented here does not have an automatic stopping criterion. Hence, it will
always run the number of iterations specified by the user. Also, convergence is not
monitored and left to the user. This can easily be done with coda::gelman.diag(chain).
Further the proposed delayed rejectio step in Vrugt et al. (2009) is not implemented here.\cr\cr
During the adaptation phase DREAM is running two mechanisms to enhance the sampler's efficiency.
First the disribution of crossover values is tuned to favor large jumps in the parameter space.
The crossover probabilities determine how many parameters are updated simultaneously. 
Second outlier chains are replanced as they can largely deteriorate the sampler's performance.
However, these steps destroy the detailed balance of the chain. Consequently these parts of the chain
should be discarded when summarizing posterior moments. This can be done automatically during the
sampling process (i.e. burnin > adaptation) or subsequently by the user. We chose to distinguish between
the burnin and adaptation phase to allow the user more flexibility in the sampler's settings.
}
\references{
Vrugt, Jasper A., et al. "Accelerating Markov chain Monte Carlo simulation by differential evolution with self-adaptive randomized subspace sampling." International Journal of Nonlinear Sciences and Numerical Simulation 10.3 (2009): 273-290.

ter  Braak C. J. F., and Vrugt J. A. (2008). Differential Evolution Markov Chain with snooker updater and fewer chains. Statistics and Computing http://dx.doi.org/10.1007/s11222-008-9104-9
}
\seealso{
\code{\link{DREAM}}
}
\author{
Stefan Paul
}
