% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classPrior.R
\name{createTruncatedNormalPrior}
\alias{createTruncatedNormalPrior}
\title{Convenience function to create a truncated normal prior}
\usage{
createTruncatedNormalPrior(mean, sd, lower, upper)
}
\arguments{
\item{mean}{best estimate for each parameter}

\item{sd}{sdandard deviation}

\item{lower}{vector of lower prior range for all parameters}

\item{upper}{vector of upper prior range for all parameters}
}
\description{
Convenience function to create a truncated normal prior
}
\note{
for details see \code{\link{createPrior}}
}
\examples{
prior <- createTruncatedNormalPrior(c(0,0),c(0.4,5), lower = c(-2,-2), upper = c(1,1))
prior$density(c(2,3))
prior$density(c(0.2,0.9))
prior$sampler()
}
\seealso{
\code{\link{createPriorDensity}} \cr
         \code{\link{createPrior}} \cr
         \code{\link{createBetaPrior}} \cr
         \code{\link{createUniformPrior}} \cr
         \code{\link{createBayesianSetup}} \cr
}
\author{
Florian Hartig
}
