% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessDesign.R
\name{assessDesign}
\alias{assessDesign}
\title{assessDesign}
\usage{
assessDesign(
  n_patients,
  mods,
  prior_list,
  sd = NULL,
  contr = NULL,
  dr_means = NULL,
  data_sim = NULL,
  estimates_sim = NULL,
  n_sim = 1000,
  alpha_crit_val = 0.05,
  modeling = FALSE,
  simple = TRUE,
  avg_fit = TRUE,
  reestimate = FALSE,
  delta = NULL,
  evidence_level = NULL,
  n_bs_samples = 1000,
  med_selection = c("avgFit", "bestFit"),
  probability_scale = FALSE
)
}
\arguments{
\item{n_patients}{Vector specifying the planned number of patients per dose group. A minimum of 2 patients are required in each group.}

\item{mods}{An object of class \code{Mods} as specified in the \code{DoseFinding} package.}

\item{prior_list}{A prior_list object specifying the utilized prior for the different dose groups}

\item{sd}{A positive value, specification of assumed sd. Not required if either \code{data_sim} or \code{estimates_sim} is provided. Also not required in case of binary endpoint. Default NULL}

\item{contr}{An object of class \code{optContr} as created by the \code{DoseFinding::getContr} function. Allows specification of a fixed contrasts matrix. Default NULL.}

\item{dr_means}{A vector, allows specification of individual (not model based) assumed effects per dose group. Default NULL.}

\item{data_sim}{An optional data frame for custom simulated data. Must follow the data structure as provided by \code{simulateData()}. Default NULL.}

\item{estimates_sim}{An optional named list of 1) list of vectors for the estimated means per dose group (\code{estimates_sim$mu_hats}) and 2) of list of matrices for the covariance matrices specifying the (estimated) variabilities (\code{estimates_sim$S_hats}). Dimensions of entries must match the number of dose levels. Default NULL.}

\item{n_sim}{Number of simulations to be performed}

\item{alpha_crit_val}{(Un-adjusted) Critical value to be used for the MCP testing step. Passed to the \code{getCritProb} function for the calculation of adjusted critical values (on the probability scale). Default 0.05.}

\item{modeling}{Boolean variable defining whether the Mod part of Bayesian MCP-Mod will be performed in the assessment. More heavy on resources. Default FALSE.}

\item{simple}{Boolean variable defining whether simplified fit will be applied, see \code{?getModelFits}. Set automatically to TRUE if argument \code{delta} is provided. Passed to \code{getModelFits} Default TRUE.}

\item{avg_fit}{Boolean variable, defining whether an average fit (based on generalized AIC weights) should be performed in addition to the individual models. Default TRUE.}

\item{reestimate}{Boolean variable defining whether critical value should be calculated with re-estimated contrasts (see \code{getCritProb} function for more details). Default FALSE.}

\item{delta}{A numeric value for the threshold Delta for the MED assessment. If NULL, no MED assessment is performed. Default NULL.}

\item{evidence_level}{A numeric value between 0 and 1 for the evidence level gamma for the MED assessment. Only required for Bayesian MED assessment, see \code{?getMED} for details. If NULL, MED assessment will be performed on the fitted model according to the argument \code{med_selection}.  Default NULL.}

\item{n_bs_samples}{Number of bootstrap samples for the MED assessment if \code{evidence_level} is provided. Note that more extreme quantiles (i.e., quantiles closer to 0 or 1) tend to require more bootstrap samples to maintain precision. Default 1000.}

\item{med_selection}{A string, either \code{"avgFit"} or \code{"bestFit"}, for the method of MED selection. Default \code{"avgFit"}.}

\item{probability_scale}{A boolean to specify if the trial has a continuous or a binary outcome. Setting to TRUE will transform calculations from the logit scale to the probability scale, which can be desirable for a binary outcome. Default FALSE.}
}
\value{
Returns success probabilities for the different assumed dose-response shapes, attributes also includes information around average success rate (across all assumed models) and prior Effective sample size.
}
\description{
This function performs simulation based trial design evaluations for a set of specified dose-response models
}
\examples{
mods <- DoseFinding::Mods(linear      = NULL,
                          emax        = c(0.5, 1.2),
                          exponential = 2,
                          betaMod     = c(1, 1),
                          doses       = c(0, 0.5, 2,4, 8),
                          maxEff      = 6)
                          
sd <- 12
prior_list <- list(Ctrl = RBesT::mixnorm(comp1 = c(w = 1, m = 0, s = 12), sigma = 2),
                   DG_1 = RBesT::mixnorm(comp1 = c(w = 1, m = 1, s = 12), sigma = 2),
                   DG_2 = RBesT::mixnorm(comp1 = c(w = 1, m = 1.2, s = 11), sigma = 2) ,
                   DG_3 = RBesT::mixnorm(comp1 = c(w = 1, m = 1.3, s = 11), sigma = 2) ,
                   DG_4 = RBesT::mixnorm(comp1 = c(w = 1, m = 2, s = 13), sigma = 2))
n_patients <- c(40, 60, 60, 60, 60)
dose_levels  <- c(0, 0.5, 2, 4, 8)

success_probabilities <- assessDesign(
  n_patients  = n_patients,
  mods        = mods,
  prior_list  = prior_list,
  sd          = sd,
  n_sim       = 1e2) # speed up example run time

success_probabilities

## Analysis with custom data
data_sim <- simulateData(
  n_patients        = n_patients,
  dose_levels       = dose_levels,
  sd                = sd,
  mods              = mods,
  n_sim             = 10)

success_probabilities_cd <- assessDesign(
  n_patients  = n_patients,
  mods        = mods,
  prior_list  = prior_list,
  data_sim    = data_sim,
  sd          = sd,
  n_sim       = 1e2) # speed up example run time

success_probabilities_cd

## Analysis with custom dose response relationship
custom_dr_means <- c(1, 2, 3, 4, 5)

success_probs_custom_dr <- assessDesign(
  n_patients  = n_patients,
  mods        = mods,
  prior_list  = prior_list,
  dr_means    = custom_dr_means,
  sd          = sd,
  n_sim       = 1e2) # speed up example run time

success_probs_custom_dr

## Analysis with custom estimates for means and variabilies
## No simulated data, only simulated model estimates
estimates_sim <- list(mu_hats = replicate(100, list(c(1, 2, 3, 4, 5) + rnorm(5, 0, 1))),
                      S_hats  = list(diag(1, 5)))

success_probs_custom_est <- assessDesign(
  n_patients    = n_patients,
  mods          = mods,
  prior_list    = prior_list,
  estimates_sim = estimates_sim)

success_probs_custom_est

if (interactive()) { # takes typically > 5 seconds

# with MED estimation without bootstrapping
# see ?getMED for details

success_probabilities <- assessDesign(
  n_patients     = n_patients,
  mods           = mods,
  prior_list     = prior_list,
  sd             = sd,
  modeling       = TRUE,
  n_sim          = 10, # speed up example run time
  delta          = 7)

  success_probabilities

# with MED estimation with bootstrapping

success_probabilities <- assessDesign(
  n_patients     = n_patients,
  mods           = mods,
  prior_list     = prior_list,
  sd             = sd,
  modeling       = TRUE,
  n_sim          = 10, # speed up example run time
  delta          = 7,
  evidence_level = 0.8)

  success_probabilities

}

}
