
#' @title Extract sub data frame from list of FROC data
#' @description Makes a dataframe
#'  from a list consisting of  vectors \code{m,q,c,h,f} and positive integers \code{NL,C,M,Q,NI}.
#'  The resulting data-frame is construceted by  vectors \code{m,q,c,h,f}.
#'
#' @param dataList A list of MRMC data.
#'
#' @return A data frame consisting of  vectors \code{m,q,c,h,f}.
#' \describe{
#' \item{ \code{m }  }{A vector of positive integers,  representing  the \emph{\strong{modality}} ID vector. }
#' \item{ \code{q }  }{A vector of positive integers,  representing  the \emph{\strong{reader}} ID vector.}
#' \item{ \code{c }  }{A vector of positive integers,  representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
#' \item{ \code{h }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{hits}}.   }
#' \item{ \code{f }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{false alarms}}.  }
#' }
#'
#' @export
#'
#' @examples
#' \dontrun{
#'
#'
#'#========================================================================================
#'#                      From example dataset named dddddd
#'#========================================================================================
#'
#'## Only run examples in interactive R sessions
#'if (interactive()) {
#'
#'  fit_GUI_Shiny_MRMC(DF=extract_data_frame_from_dataList_MRMC(dddddd))
#'
#'
#'}## Only run examples in interactive R sessions
#'
#'
#'}
#'
extract_data_frame_from_dataList_MRMC <- function(dataList){


  DF=data.frame(
    m=as.integer( dataList$m),
    q=as.integer( dataList$q),
    c=as.integer( dataList$c),
    h=as.integer( dataList$h),
    f=as.integer( dataList$f)
  )

  return(DF)
  }
