% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_degit_plot.R
\name{plot_FPF_TPF_via_dataframe_with_split_factor}
\alias{plot_FPF_TPF_via_dataframe_with_split_factor}
\title{Scatter Plot of FPFs and TPFs via Splitting Factor}
\usage{
plot_FPF_TPF_via_dataframe_with_split_factor(
  dataList.MRMC,
  ModifiedPoisson = FALSE,
  colored_by_modality = TRUE,
  numbered_by_modality = TRUE,
  cex = 1.3
)
}
\arguments{
\item{dataList.MRMC}{A list, indicating FROC data of MRMC.
See also \code{dataList} which is a variable of the function \code{\link{fit_Bayesian_FROC}()}.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}.

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per lesion}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pairs of TPF per lesion and FPF  \strong{\emph{per lesion}}.

Similarly,

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per image}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pair of TPF per lesion and FPF  \strong{\emph{per image}}.



To know details, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.
(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }, now, it is omiited from this package, because the size of vignettes are large.)

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is defined as follows
 (\eqn{F_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_L}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_L}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_L}, }

  \deqn{ \frac{F_4+F_5}{N_L}, }

   \deqn{ \frac{F_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).
To emphasize its denominator  \eqn{N_L},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per lesion}.


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\emph{False Positive Fraction (FPF)} is given by

\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_I}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_I}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_I}, }

  \deqn{ \frac{F_4+F_5}{N_I}, }

   \deqn{ \frac{F_5}{N_I}, }

where \eqn{N_I} is the number of images (trial).
To emphasize its denominator \eqn{N_I},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per image}.


The model is fitted so that
the estimated FROC curve can be ragraded
 as the expected pairs of   FPF per image and TPF per lesion (\code{ModifiedPoisson = FALSE })

 or as the expected pairs of   FPF per image and TPF per lesion  (\code{ModifiedPoisson = TRUE})

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.
This rigidity of curves means that the number of images is redundant parameter for the FROC trial and
thus the author try to exclude it.


Revised 2019 Dec 8
Revised 2019 Nov 25
Revised 2019 August 28}

\item{colored_by_modality}{A logical, if TRUE, then the color in the scatter plot means modality ID.
If not, then the each color in the scatter plot indicates reader ID.}

\item{numbered_by_modality}{A logical, if TRUE, then the number in the scatter plot means modality ID.
If not, then the each number in the scatter plot indicates reader ID.}

\item{cex}{A positive real number, specifying the size of dots in the resulting plot.}
}
\value{
A dataframe, which is added TPF and FPF, etc into \code{dataList.MRMC}.

\strong{\emph{Added Vectors as Contents of the Data-frame}}
\describe{
\item{ \code{CFP}    }{ A vector of \strong{\emph{Cumulative False Positive}}  }
\item{ \code{CTP}    }{ A vector of \strong{\emph{Cumulative True Positive }}  }
\item{ \code{TPF}    }{ A vector of \strong{\emph{True Positive Fraction   }}  }
\item{ \code{FPF}    }{ A vector of \strong{\emph{False Positive Fraction  }} per image or per lesion according to the logical variable \code{ModifiedPoisson}  }
\item{ \code{factor}    }{What this means is trivial.}
}
\strong{\emph{Vectors as Contents of the Data-frame \code{dataList.MRMC}}}

\describe{
\item{ \code{c }  }{A vector of positive integers,  representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{m }  }{A vector of positive integers,  representing  the \emph{\strong{modality}} ID vector. }
\item{ \code{q }  }{A vector of positive integers,  representing  the \emph{\strong{reader}} ID vector.}
\item{ \code{h }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{hits}}.   }
\item{ \code{f }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{false alarm}}.  }
 }
}
\description{
Make a factor vector by which we plot FPF and TPF.
}
\examples{

#========================================================================================
#                               The 1st example
#========================================================================================


v  <- v_truth_creator_for_many_readers_MRMC_data(M=1,Q=37)
m  <- mu_truth_creator_for_many_readers_MRMC_data(M=1,Q=37)
d  <- create_dataList_MRMC(mu.truth = m,v.truth = v)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality    = TRUE,
  numbered_by_modality   = TRUE)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality   = FALSE,
  numbered_by_modality   = TRUE)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality    = TRUE,
  numbered_by_modality  = FALSE)


plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality   = FALSE,
  numbered_by_modality  = FALSE)

#========================================================================================
#                               The 2-nd example
#========================================================================================
#


v  <- v_truth_creator_for_many_readers_MRMC_data(M=2,Q=37)
m  <- mu_truth_creator_for_many_readers_MRMC_data(M=2,Q=37)
d  <- create_dataList_MRMC(mu.truth = m,v.truth = v)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality    = TRUE,
  numbered_by_modality   = TRUE)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality   = FALSE,
  numbered_by_modality   = TRUE)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality    = TRUE,
  numbered_by_modality  = FALSE)


plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality   = FALSE,
  numbered_by_modality  = FALSE)



#========================================================================================
#                               The 3rd example
#========================================================================================




v  <- v_truth_creator_for_many_readers_MRMC_data(M=3,Q=7)
m  <- mu_truth_creator_for_many_readers_MRMC_data(M=3,Q=7)
d  <- create_dataList_MRMC(mu.truth = m,v.truth = v)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality    = TRUE,
  numbered_by_modality   = TRUE)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality   = FALSE,
  numbered_by_modality   = TRUE)

plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality   = TRUE,
  numbered_by_modality  = FALSE)


plot_FPF_TPF_via_dataframe_with_split_factor(d,
  colored_by_modality   = FALSE,
  numbered_by_modality  = FALSE)
#========================================================================================
#                               The 4th example
#========================================================================================




plot_FPF_TPF_via_dataframe_with_split_factor( dataList.MRMC = dd,
                                              colored_by_modality  = TRUE,
                                              numbered_by_modality = TRUE)



#========================================================================================
#                               The 5th example
#========================================================================================


a <- plot_FPF_TPF_via_dataframe_with_split_factor(dd)

p <- ggplot2::ggplot(a, ggplot2::aes(FPF, TPF,
                            group = factor(factor),
                            colour = factor(m)) ) +
   ggplot2::geom_line(size = 1.4)
print(p)





#========================================================================================
#                               The 6th example
#========================================================================================

a <- plot_FPF_TPF_via_dataframe_with_split_factor(dd,cex = 1.8)


#========================================================================================
#                               The 7th example
#========================================================================================


# Plot empirical FROC curve whose modality is specified as following manner

a <- plot_FPF_TPF_via_dataframe_with_split_factor(dd)
aa <- a[a$m == c(2,3), ]

p <- ggplot2::ggplot(aa, ggplot2::aes(FPF, TPF,
                            group = factor(factor),
                            colour = factor(m)) ) +
   ggplot2::geom_line(size = 1.4)
print(p)



# Plot empirical FROC curve whose modality is specified as following manner

a <- plot_FPF_TPF_via_dataframe_with_split_factor(dd)
aa <- a[a$m \%in\%  c(4,3), ]

p <- ggplot2::ggplot(aa, ggplot2::aes(FPF, TPF,
                            group = factor(factor),
                            colour = factor(m)) ) +
   ggplot2::geom_line(size = 1.4)
print(p)


# Plot empirical FROC curve whose modality is specified as following manner

a <- plot_FPF_TPF_via_dataframe_with_split_factor(dd)
aa <- a[a$m \%in\% c(3,4), ]

p <- ggplot2::ggplot(aa, ggplot2::aes(FPF, TPF,
                            group = factor(factor),
                            colour = factor(m)) ) +
   ggplot2::geom_line(size = 1.4)
print(p)




}
