% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_Bayesian_FROC.R
\name{fit_a_model_to}
\alias{fit_a_model_to}
\title{Fit a model to data}
\usage{
fit_a_model_to(
  dataList,
  number_of_chains_for_MCMC = 1,
  number_of_iterations_for_MCMC = 1111,
  seed_for_MCMC = 1234
)
}
\arguments{
\item{dataList}{A list, specifying an FROC data to be fitted a model.
It consists of data of numbers
of TPs, FPs, lesions, images.
.In addition, if in case of  mutiple readers or mutiple modalities,
then modaity ID and reader ID are included also.

 The \code{dataList} will be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}. This is a variable in the function \code{rstan::sampling()} in which it is named \code{data}.



 For the single reader and a single modality data, the \code{dataList} is made by the following manner:

\code{ dataList.Example <- list(       }

\code{            h = c(41,22,14,8,1),  # number of hits for each confidence level }

\code{            f = c(1,2,5,11,13),  # number of false alarms for each confidence level   }

\code{            NL = 124,  # number of lesions (signals)   }

\code{            NI = 63,  # number of images (trials)  }

\code{            C = 5)   # number of confidence, .. the author thinks it can be calculated as the length of h or f ...? ha, why I included this. ha .. should be omitted.      }

And using this object \code{dataList.Example}, we can apply \code{fit_Bayesian_FROC()} such as \code{fit_Bayesian_FROC(dataList.Example)}.






To make this \R object \code{dataList} representing FROC data, this package provides three functions:
\describe{
\item{  \code{ \link{convertFromJafroc}()}           }{ If  data is a           \emph{\strong{JAFROC xlsx}} formulation.}
\item{  \code{ \link{dataset_creator_new_version}()} }{ Enter TP and FP data    \emph{\strong{by table   }}.            }
\item{  \code{ \link{create_dataset}()}              }{ Enter TP and FP data by \emph{\strong{interactive}} manner.     }
}

Before fitting a model,
 we can confirm our dataset is correctly formulated
 by using the function \strong{\code{ \link{viewdata}()}}.


----------------------------------------------------------------------------------------


  \strong{A Single reader and a single modality (SRSC) case.}


----------------------------------------------------------------------------------------

In a single reader and a single modality case (srsc),
\code{dataList} is a list consisting of  \code{f, h, NL, NI, C} where
 \code{f, h} are numeric vectors
 and  \code{NL, NI, C} are positive integers.

\describe{
\item{ \code{f}  }{Non-negative integer vector  specifying  number of False Alarms   associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{h}  }{Non-negative integer vector  specifying  number  of Hits  associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{NL} }{A positive integer, representing  Number of Lesions.}
\item{ \code{NI} }{A positive integer, representing  Number of Images. }
\item{ \code{C}  }{A positive integer, representing  Number of Confidence level. }
}




The detail of these dataset, see the datasets  endowed with this package.
'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
Note that confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} in the program and do not refer from user input data, where \code{C} is the highest number of confidence levels.
So, you should write down your hits and false alarms vector so that it is compatible with this automatically created \code{c} vector.


\strong{\emph{ data Format:}}

 \emph{            A single reader and a single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
definitely present  \tab  \code{c[1] = }5 \tab \code{f[1] = }\eqn{F_5} = 1 \tab  \code{h[1] = }\eqn{H_5} = 41 \cr
 probably present   \tab  \code{c[2] = }4 \tab \code{f[2] = }\eqn{F_4} = 2 \tab  \code{h[2] = }\eqn{H_4} = 22 \cr
 equivocal                 \tab  \code{c[3] = }3 \tab \code{f[3] = }\eqn{F_3} = 5 \tab  \code{h[3] = }\eqn{H_3} = 14  \cr
 subtle                    \tab  \code{c[4] = }2 \tab \code{f[4] = }\eqn{F_2} = 11 \tab \code{h[4] = }\eqn{H_2} = 8  \cr
 very subtle        \tab  \code{c[5] = }1 \tab \code{f[5] = }\eqn{F_1} = 13 \tab \code{h[5] = }\eqn{H_1} = 1  \cr
 }

---------------------------------------------------------------------------------------------------



*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP

Note that  in FROC data, all confidence level means \emph{present} (\emph{diseased, lesion}) case only, no confidence level indicating absent. Since each reader marks his suspicious location only if he thinks  lesions are \emph{present}, and marked positions generates the hits or false alarms, \emph{thus} each confidence level represents that lesion is \emph{present}.
In the absent case, reader dose not mark any locations and hence, the absent confidence level does not relate this dataset. So, if reader think it is no lesion, then in such case confidence level is not needed.


Note that the first column of confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} automatically in the program and do not refer from user input data even if it is specified explicitly, where \code{C} is the highest number of confidence levels.
So you should check the compatibility of your
data and the confidence  level vector  \code{  c <-c(rep(C:1))}
via a table which can be displayed by the function \code{\link{viewdata}()}.









---------------------------------------------------------------------------------------

  \strong{Multiple readers and multiple modalities case, i.e., MRMC case}


---------------------------------------------------------------------------------------


In case of  multiple readers and multiple modalities, i.e., MRMC case,
in order to apply the function \code{fit_Bayesian_FROC()},
dataset represented by an \R list object representing FROC data
must contain components \code{m,q,c,h,f,NL,C,M,Q}.

\describe{
\item{ \code{C }  }{A positive integer, representing  the \emph{\strong{highest}} number of confidence level, this is a scalar.}
\item{ \code{M }  }{A positive integer vector, representing  the number of \emph{\strong{modalities}}.  }
\item{ \code{Q }  }{A positive integer, representing  the number of \emph{\strong{readers}}. }
\item{ \code{m }  }{A vector of positive integers,  representing  the \emph{\strong{modality}} ID vector. }
\item{ \code{q }  }{A vector of positive integers,  representing  the \emph{\strong{reader}} ID vector.}
\item{ \code{c }  }{A vector of positive integers,  representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{h }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{hits}}.   }
\item{ \code{f }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{false alarms}}.  }
\item{ \code{NL}  }{A positive integer, representing  the Total number of \emph{\strong{lesions}} for all images, this is a scalar.}
}



Note that the maximal number of confidence level (denoted by  \code{C}) are included in
the above \R object.
However,
each confidence level vector is not included in the data,
 because it is created automatically from \code{C}.
  To confirm  false positives and hits
are correctly ordered with respect to
 the automatically generated confidence vector,

the function \code{\link{viewdata}()} shows the table.
Revised 2019 Nov 27
Revised 2019 Dec 5



\strong{\emph{ Example data. }}



 \emph{ Multiple readers and multiple modalities ( i.e., MRMC) }




---------------------------------------------------------------------------------------------------

\tabular{ccccc}{
 \strong{Modality ID } \tab   \strong{Reader ID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{m} \tab  \code{ q}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
   -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
  1 \tab 1 \tab 3 \tab 20 \tab 111\cr
  1 \tab 1 \tab 2 \tab 29 \tab  55\cr
  1 \tab 1 \tab 1 \tab 21 \tab  22\cr
  1 \tab 2 \tab 3 \tab  6 \tab 100\cr
  1 \tab 2 \tab 2 \tab 15 \tab  44\cr
  1 \tab 2 \tab 1 \tab 22 \tab  11\cr
  2 \tab 1 \tab 3 \tab  6 \tab  66\cr
  2 \tab 1 \tab 2 \tab 24 \tab  55\cr
  2 \tab 1 \tab 1 \tab 23 \tab   1\cr
  2 \tab 2 \tab 3 \tab  5 \tab  66\cr
  2 \tab 2 \tab 2 \tab 30 \tab  55\cr
  2 \tab 2 \tab 1 \tab 40 \tab  44\cr
}
---------------------------------------------------------------------------------------------------




*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP}

\item{number_of_chains_for_MCMC}{A positive integer, indicating the number of chains for MCMC. To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}.}

\item{number_of_iterations_for_MCMC}{A positive integer, indicating the number of interations for MCMC. To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}.}

\item{seed_for_MCMC}{A positive integer, indicating the seed for MCMC. To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}.}
}
\value{
An fitted model
object of the S4 class named  \code{\link{stanfitExtended}}  which is an inherited class from stanfit.
}
\description{
Fit a model to data.
}
\details{
The author made a function
\code{\link{fit_Bayesian_FROC}()} which has
very redundant variables.
So, \code{fit_a_model_to()} is made by simplifying \code{\link{fit_Bayesian_FROC}()}
so that its variables is minimum.
To access full details,
see the help of \code{\link{fit_Bayesian_FROC}()}.

This function aims to give a simple interface by ignoring unnecessarly parameters of \code{\link{fit_Bayesian_FROC}()}.
}
\examples{
\donttest{

#========================================================================================
#            1)             Build a data-set
#========================================================================================

# For a single reader and a single modality  case.

    data <- list(c=c(3,2,1),    #     Confidence level. Note that c is ignored.
            h=c(97,32,31), #     Number of hits for each confidence level
            f=c(1,14,74),  #     Number of false alarms for each confidence level

            NL=259,        #     Number of lesions
            NI=57,         #     Number of images
            C=3)           #     Number of confidence level


         viewdata(data)

#  where,
#      c denotes confidence level, i.e., rating of reader.
#                3 = Definitely diseased,
#                2 = subtle,.. diseased
#                1 = very subtle
#      h denotes number of hits (True Positives: TP) for each confidence level,
#      f denotes number of false alarms (False Positives: FP) for each confidence level,
#      NL denotes number of lesions,
#      NI denotes number of images,


# For example, in the above example data,
#  the number of hits with confidence level 3 is 97,
#  the number of hits with confidence level 2 is 32,
#  the number of hits with confidence level 1 is 31,

#  the number of false alarms with confidence level 3 is 1,
#  the number of false alarms with confidence level 2 is 14,
#  the number of false alarms with confidence level 1 is 74,


#========================================================================================
#                         2)       Fit an FROC model to the above dataset.
#========================================================================================






          fit <-   BayesianFROC::fit_a_model_to(
#  Dataset to be fiited
                     dataList = data,

#  To run in time <5s, MCMC iterations too small to obtain reliable estimates
number_of_iterations_for_MCMC = 1111,

#  The number of chains, it is better  if larger.
number_of_chains_for_MCMC     = 1
                               )
}


}
\seealso{
\code{\link{fit_Bayesian_FROC}()}
}
