% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validation.dataset_srsc}
\alias{validation.dataset_srsc}
\title{Dataset creator from known distributions}
\usage{
validation.dataset_srsc(replicate.datset = 3, ModifiedPoisson = FALSE,
  mean.truth = 0.6, sd.truth = 5.3, z.truth = c(-0.8, 0.7, 2.38),
  NL = 259, NI = 57, ite = 1111, summary = TRUE)
}
\arguments{
\item{replicate.datset}{A Number indicate that how many you replicate dataset from user's specified dataset.}

\item{ModifiedPoisson}{This is dichotomous, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm are \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm are \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.}

\item{mean.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{sd.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{z.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{NL}{Number of Lesions.}

\item{NI}{Number of Images.}

\item{ite}{An argument of \code{rstan::stan()} in which it is named \code{iter}.  It means the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number.}

\item{summary}{TRUE or FALSE. If TRUE then summary and estimates are printed in the R console. If FALSE, the output is minimal.}
}
\value{
Return values is,

stanfit objects, more precisely some inherited class, for each replicated dataset.
}
\description{
By specifying the parameters of bi-normal assumptions,
( that is, mean and sd of the signal latent Gaussian distribution)
the dataset are created from this known distributions.
The number of lesions and the number of images corresponds the sample size of each replicated dataset.

This function also fit a srsc FROC model for each replicated dataset.
}
\examples{
\donttest{
#================The first example======================================



#   Using the default values, the code run, i.e.:

   datasets <- validation.dataset_srsc()



#================The second example======================================

#   If user do not familiar with the values of thresholds, then
#   it would be better to use the actual estimated values
#    as an example of true parameters. In the following,
#     I explain this.

# First, get estimators by

  fit <- fit_Bayesian_FROC(dataList.Chakra.1,ite = 1111,summary =FALSE,cha=3)

#  Secondly, extract the expected a posterior estimators (EAPs) from the object fit

  z <- rstan::get_posterior_mean(fit,par=c("z"))[,"mean-all chains"]

#  Thirdly we use this z as a true values. If user does not know
#   the scale or ordinal values of thersholds, by using fitted values,
#     user can use this function to replicate datasets.

   datasets <- validation.dataset_srsc(z.truth = z)



}# dottest
}
