% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicate_MRMC_data.R
\name{hits_creator_from_rate}
\alias{hits_creator_from_rate}
\title{MRMC Dataset Creator From Hit Rate.}
\usage{
hits_creator_from_rate(NL = 252, seed = 123,
  p.truth = BayesianFROC::p_truth)
}
\arguments{
\item{NL}{Number of Lesions.}

\item{seed}{The seed for creating hits which are generated by the binomial distributions with the specified seed.}

\item{p.truth}{Array of dimension ( C, M, Q), where
C = number of confidence levels,
M = number of modalities,
Q = number of readers.}
}
\value{
Hits Data
}
\description{
From hit rates, data of hits are created.
}
\examples{
\donttest{

#  Using the default hit values, hit data are created as follows;

           hits <- hits_creator_from_rate()


# If user want to use their own hit rates, then please input as same as
# the default values manner.
#================The third example======================================

#     The hits rate cannot take any values, since there is a trend that a hit rate of
#   a higher confidence level is a higher. So, If it is difficult for user to create
#   a true hit rates, then  by taking estimates as true parameters,
#   user can replicate datasets.
#     To do so, work follow is first fitting, secondly extracting estimates,
#   thirdly apply this function (hits_creator_from_rate() ).


# * Fitting

     fit <- fit_Bayesian_FROC(
             dataList.Chakra.Web.orderd,
             ite = 1111,  #  For simplicity, we take small MCMC samples.
             summary =FALSE)

# * Extracting

        estimates <- extract_estimates_MRMC(fit)

         ppp <- estimates$ppp.EAP

#      Note that ppp is an array
#     whose dimension is constituted by number of confidence levels, modalities, readers.


# *  Replicating as an true values is ppp


        hits  <-   hits_creator_from_rate(p.truth = ppp )


# <<Remark>>
#     ppp is an array. But ignoring its dimension, we can write that

#          hits ~ Binomial(ppp, NL)

#    Where NL is a number of lesions.

#   By writing its component explicitly, we can write

#        Hits[c,m,r] ~ Binomial(ppp[c,m,r], NL)

#        Where c means the c-th confidence level,
#              m  means the m-th modality,
#              r means the r-th reader.
}# dottest
}
\keyword{=}
\keyword{True}
\keyword{binomial}
\keyword{distributions,}
\keyword{distributions.}
\keyword{hit}
\keyword{of}
\keyword{positives,}
\keyword{probability}
\keyword{rate}
