% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{run_mcmc}
\alias{run_mcmc}
\title{Worker function for computing the posterior distribution.}
\usage{
run_mcmc(rankings, nmc, constraints, cardinalities, logz_estimate,
  rho_init, metric = "footrule", error_model = "none",
  n_clusters = 1L, include_wcd = FALSE, leap_size = 1L,
  alpha_prop_sd = 0.5, alpha_init = 5, alpha_jump = 1L,
  lambda = 0.1, psi = 10L, rho_thinning = 1L, aug_thinning = 1L,
  clus_thin = 1L, save_aug = FALSE, verbose = FALSE, kappa_1 = 1,
  kappa_2 = 1)
}
\arguments{
\item{rankings}{A set of complete rankings, with one sample per column.
With n_assessors samples and n_items items, rankings is n_items x n_assessors.}

\item{nmc}{Number of Monte Carlo samples.}

\item{constraints}{List of lists of lists, returned from `generate_constraints`.}

\item{cardinalities}{Used when metric equals \code{"footrule"} or
\code{"spearman"} for computing the partition function. Defaults to
\code{R_NilValue}.}

\item{logz_estimate}{Estimate of the log partition function.}

\item{metric}{The distance metric to use. One of \code{"spearman"},
\code{"footrule"}, \code{"kendall"}, \code{"cayley"}, or
\code{"hamming"}.}

\item{n_clusters}{Number of clusters. Defaults to 1.}

\item{include_wcd}{Boolean defining whether or
not to store the within-cluster distance.}

\item{leap_size}{Leap-and-shift step size.}

\item{alpha_prop_sd}{Standard deviation of proposal distribution for alpha.}

\item{alpha_init}{Initial value of alpha.}

\item{alpha_jump}{How many times should we sample \code{rho} between
each time we sample \code{alpha}. Setting \code{alpha_jump} to a high
number can significantly speed up computation time, since we then do not
have to do expensive computation of the partition function.}

\item{lambda}{Parameter of the prior distribution.}

\item{psi}{Hyperparameter for the Dirichlet prior distribution used in clustering.}

\item{rho_thinning}{Thinning parameter. Keep only every \code{rho_thinning} rank
sample from the posterior distribution.}

\item{aug_thinning}{Integer specifying the thinning for data augmentation.}

\item{clus_thin}{Integer specifying the thinning for saving cluster assignments.}

\item{save_aug}{Whether or not to save the augmented data every
\code{aug_thinning}th iteration.}

\item{verbose}{Logical specifying whether to print out the progress of the
Metropolis-Hastings algorithm. If \code{TRUE}, a notification is printed every
1000th iteration.}

\item{kappa_1}{Hyperparameter for \eqn{theta} in the Bernoulli error model. Defaults to 1.0.}

\item{kappa_2}{Hyperparameter for \eqn{theta} in the Bernoulli error model. Defaults to 1.0.}
}
\description{
Worker function for computing the posterior distribution.
}
\keyword{internal}
