% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cace.meta.ic.R
\name{cace.meta.ic}
\alias{cace.meta.ic}
\title{Bayesian hierarchical models for CACE meta-analysis with incomplete compliance information}
\usage{
cace.meta.ic(
  data,
  param = c("CACE", "u1out", "v1out", "s1out", "b1out", "pic", "pin", "pia"),
  prior.type = "default",
  delta.n = TRUE,
  delta.a = TRUE,
  delta.u = TRUE,
  delta.v = TRUE,
  delta.s = TRUE,
  delta.b = TRUE,
  cor = TRUE,
  digits = 3,
  n.adapt = 1000,
  n.iter = 1e+05,
  n.burnin = floor(n.iter/2),
  n.chains = 3,
  n.thin = max(1, floor((n.iter - n.burnin)/1e+05)),
  conv.diag = FALSE,
  mcmc.samples = FALSE,
  study.specific = FALSE
)
}
\arguments{
\item{data}{a input dataset the same structure as the example data `epidural_ic`, 
containing multiple rows referring to multiple studies in a meta-analysis.}

\item{param}{the list of parameter used. Default to c("CACE", "u1out", "v1out", "s1out", "b1out", 
"pic", "pin", "pia")}

\item{prior.type}{the default priors are used by the default assignment `prior.type="default"`.}

\item{delta.n}{value for delta.n}

\item{delta.a}{value for delta.a}

\item{delta.u}{value for delta.u}

\item{delta.v}{value for delta.v}

\item{delta.s}{value for delta.s}

\item{delta.b}{value for delta.b}

\item{cor}{correlation}

\item{digits}{number of digits. Default to 3.}

\item{n.adapt}{adapt value. Default to 1000.}

\item{n.iter}{number of iterations. Default to 100000.}

\item{n.burnin}{number of burn-in iterations. Default to n.iter/2.}

\item{n.chains}{number of chains. Default to 3.}

\item{n.thin}{Default to max(1,floor((n.iter-n.burnin)/100000)).}

\item{conv.diag}{Default to False.}

\item{mcmc.samples}{Default to False.}

\item{study.specific}{a logical value indicating whether to calculate the study-specific 
\eqn{\theta^{CACE}_i}. If `TRUE`, the model will first check the logical status of arguments 
\code{delta.u} and \code{delta.v}. If both are `FALSE`, meaning that neither response rate \eqn{u_{i1}} 
or \eqn{v_{i1}} is modeled with a random effect, then the study-specific \eqn{\theta^{CACE}_i} is 
the same across studies. The function gives a warning and continues by making `study.specific = FALSE`. 
Otherwise, the study-specific \eqn{\theta^{CACE}_i} are estimated and saved as the parameter \code{cacei}.}
}
\value{
It returns a model object of class "cace.Bayes"
}
\description{
This function also estimates \eqn{\theta^{CACE}} using the Bayesian hierarchcal model 
but can accommodate studies with incomplete compliance data.  
The necessary data structure and the likelihood function are presented Section 2.3, 
CACE for meta-analysis with incomplete compliance information.
}
\details{
Note that when compiling the \code{JAGS} model, the warning `adaptation incomplete` may 
occasionally occur, indicating that the number of iterations for the adaptation process 
is not sufficient. The default value of \code{n.adapt} (the number of iterations for adaptation) 
is 1,000. This is an initial sampling phase during which the samplers adapt their behavior 
to maximize their efficiency (e.g., a Metropolis--Hastings random walk algorithm may change 
its step size). The `adaptation incomplete` warning indicates the MCMC algorithm may not 
achieve maximum efficiency, but it generally has little impact on the posterior estimates 
of the treatment effects. To avoid this warning, users may increase \code{n.adapt}.
}
\examples{
\donttest{
data("epidural_ic", package = "BayesCACE")
set.seed(123)
out.meta.ic <- cace.meta.ic(data = epidural_ic, conv.diag = TRUE, 
mcmc.samples = TRUE, study.specific = TRUE)
}
}
\references{
{
\insertRef{zhou2019bayesian}{BayesCACE}
\insertRef{zhou2020software}{BayesCACE}
}
}
\seealso{
\code{\link[BayesCACE]{cace.study}}, \code{\link[BayesCACE]{cace.meta.c}}
}
