% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.segregation.R
\name{test.segregation.of.a.marker}
\alias{test.segregation.of.a.marker}
\title{test.segregation.of.a.marker}
\usage{
test.segregation.of.a.marker(x, marker)
}
\arguments{
\item{x}{an object of class \code{onemap}, with data and additional information.}

\item{marker}{the marker which will be tested for its segregation.}
}
\value{
a list with the H0 hypothesis being tested, the chi-square statistics,
the associated p-values, and the \% of individuals genotyped.

It returns \code{NA} if the numbers of expected and observed classes are
different or if dominant and co-dominant coding is mixed in the same marker.

data(example.out) # Loads a fake outcross dataset installed with onemap
test.segregation.of.a.marker(example.out,1)
}
\description{
Applies the chi-square test to check if markers are following the
expected segregation pattern, i. e., 1:1:1:1 (A), 1:2:1 (B), 3:1 (C) and 1:1 (D)
according to OneMap's notation. It does not use Yate's correction.
}
\details{
First, the function selects the correct segregation pattern, then it
defines the H0 hypothesis, and then tests it, together with percentage of
missing data.
}
