% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{addOrg}
\alias{addOrg}
\alias{addOrg,Arena-method}
\title{Add individuals to the environment}
\usage{
addOrg(object, specI, amount, x = NULL, y = NULL, growth = NA,
  mean = 0.489, sd = 0.132)

\S4method{addOrg}{Arena}(object, specI, amount, x = NULL, y = NULL,
  growth = NA, mean = 0.489, sd = 0.132)
}
\arguments{
\item{object}{An object of class Arena.}

\item{specI}{An object of class Organism.}

\item{amount}{A numeric number giving the number of individuals to add.}

\item{x}{A numeric vector giving the x positions of individuals on the grid.}

\item{y}{A numeric vector giving the y positions of individuals on the grid.}

\item{growth}{A numeric vector giving the starting biomass of the individuals.}

\item{mean}{A numeric giving the mean of starting biomass (used for normal distribution) if growth is not defined}

\item{sd}{A numeric giving the standard derivation of starting biomass (used for normal distribution) if growth is not defined}
}
\description{
The generic function \code{addOrg} adds individuals to the environment.
}
\details{
The arguments \code{x} and \code{y} should be in the same length as the number of organisms added (given by the argument \code{amount}).
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
}
\seealso{
\code{\link{Arena-class}} and \code{\link{Bac-class}}
}

