% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.generalParams}
\alias{bgnbd.generalParams}
\title{Define general parameters}
\usage{
bgnbd.generalParams(params, func, x, t.x, T.cal, T.star = NULL, hardie = NULL)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that
order. r and alpha are unobserved parameters for the NBD transaction
process. a and b are unobserved parameters for the Beta geometric dropout
process.}

\item{func}{function calling dc.InputCheck}

\item{x}{number of repeat transactions in the calibration period T.cal, or a
vector of transaction frequencies.}

\item{t.x}{time of most recent repeat transaction, or a vector of recencies.}

\item{T.cal}{length of calibration period, or a vector of calibration period
lengths.}

\item{T.star}{length of time for which we are calculating the expected number
of transactions.}

\item{hardie}{if TRUE, use \code{\link{h2f1}} instead of
\code{\link[hypergeo]{hypergeo}} when you call this function from within
\code{\link{bgnbd.ConditionalExpectedTransactions}}.}
}
\value{
a list with things you need for \code{\link{bgnbd.LL}},
\code{\link{bgnbd.PAlive}} and
\code{\link{bgnbd.ConditionalExpectedTransactions}}
}
\description{
This is to ensure consistency across all functions that require common bits
and bobs.
}
\seealso{
\code{\link{bgnbd.LL}}

\code{\link{bgnbd.PAlive}}

\code{\link{bgnbd.ConditionalExpectedTransactions}}
}
