% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{predict.btsr}
\alias{predict.btsr}
\title{Predict method for BTSR}
\usage{
\method{predict}{btsr}(object, newdata, nnew = 0, ...)
}
\arguments{
\item{object}{Object of class inheriting from \code{"btsr"}}

\item{newdata}{A matrix with new values for the regressors.   If omitted
and \code{"xreg"} is present in the model, the fitted values are returned.
If the model does not include regressors, the functions will use
the value of \code{nnew}.}

\item{nnew}{number of out-of-sample forecasts required. If \code{newdata} is
provided, \code{nnew} is ignored.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list with the following arguments

 \item{series}{The original time series yt.}

 \item{xreg}{The original regressors (if any).}

 \item{fitted.values}{The in-sample forecast given by \eqn{\mu_t}.}

 \item{etat}{In-sample values of \eqn{g(\mu[t])}.}

 \item{error}{The error term (depends on the argument \code{error.scale})}

 \item{residuals}{The (in-sample) residuals, that is, the observed minus the predicted values.
 Same as error when \code{error.scale} = 0}

 \item{forecast}{The predicted values for yt.}

 \item{TS}{only for \code{"BARC"} models. The iterated map.}

 \item{Ts.forecast}{only for \code{"BARC"} models. The predicted values
 of the iterated map.}
}
\description{
Predicted values based on btsr object.
}
\details{
\code{predict.btsr} produces predicted values, obtained by evaluating
  the regression function in the frame \code{newdata}.

  If \code{newdata} is omitted the predictions are based on the data
  used for the fit.

  For now, prediction intervals are not provided.
}
\examples{
 #------------------------------------------------------------
 # Generating a Beta model were mut does not vary with time
 # yt ~ Beta(a,b), a = mu*nu, b = (1-mu)*nu
 #------------------------------------------------------------

y <- btsr.sim(model= "BARFIMA", linkg = "linear",
               n = 100, seed = 2021,
               coefs = list(alpha = 0.2, nu = 20))

# fitting the model
f <- btsr.fit(model = "BARFIMA", yt = y, report = TRUE,
             start = list(alpha = 0.5, nu = 10),
             linkg = "linear", d = FALSE)

pred = predict(f, nnew = 5)
pred$forecast

}
