% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BT_CV_Errors.R
\name{BT_cv_errors}
\alias{BT_cv_errors}
\title{Cross-validation errors.}
\usage{
BT_cv_errors(BT_cv_fit, cv.folds, folds)
}
\arguments{
\item{BT_cv_fit}{a \code{\link{BTCVFit}} object.}

\item{cv.folds}{a numeric corresponding to the number of folds.}

\item{folds}{a numerical vector containing the different \code{folds.id}. Note that if the latter was not defined by the user, those are randomly generated based on the \code{cv.folds} input.}
}
\value{
Vector containing the cross-validation errors w.r.t. the boosting iteration.
}
\description{
Function to compute the cross-validation error.
}
\details{
This function computes the global cross-validation error as a function of the boosting iteration. Differently said, this measure is obtained by
computing the average of out-of-fold errors.
}
\references{
M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |: GLMs and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries ||: Tree-Based Methods and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |||: Neural Networks and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2022). \strong{Response versus gradient boosting trees, GLMs and neural networks under Tweedie loss and log-link}.
Accepted for publication in \emph{Scandinavian Actuarial Journal}.

M. Denuit, J. Huyghe and J. Trufin (2022). \strong{Boosting cost-complexity pruned trees on Tweedie responses: The ABT machine for insurance ratemaking}.
Paper submitted for publication.

M. Denuit, J. Trufin and T. Verdebout (2022). \strong{Boosting on the responses with Tweedie loss functions}. Paper submitted for publication.
}
\seealso{
\code{\link{BT}}.
}
\author{
Gireg Willame \email{gireg.willame@gmail.com}

\emph{This package is inspired by the \code{gbm3} package. For more details, see \url{https://github.com/gbm-developers/gbm3/}}.
}
