% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4-PENALTY.R
\docType{class}
\name{PENALTY-class}
\alias{PENALTY-class}
\alias{PENALTY}
\alias{PENALTYclass}
\alias{show,PENALTY-method}
\alias{plot,PENALTY,ANY-method}
\alias{getPenalty,BSL-method}
\title{S4 class ``PENALTY''}
\usage{
\S4method{show}{PENALTY}(object)

\S4method{plot}{PENALTY,ANY}(x, logscale = TRUE)

\S4method{getPenalty}{BSL}(object)
}
\arguments{
\item{object}{The S4 object of class ``PENALTY'' to show.}

\item{x}{The S4 object of class ``PENALTY'' to plot.}

\item{logscale}{A logical argument whether the x-axis (penalty) should be log transformed. The
default is \code{TRUE}.}
}
\description{
This S4 class contains the penalty selection result from
  function \code{\link{selectPenalty}}. \code{show} display the penalty
  selection result. \code{plot} plot the penalty selection result using
  ggplot2.
}
\section{Slots}{

\describe{
\item{\code{loglike}}{A list of the log-likelihood values. The list contains multiple
matrices (each corresponds to the result for a specific n value). The
number of row of the matrix equals to the number of repeats \code{M}. The
columns of the matrix stands for different penalty values.}

\item{\code{n}}{A vector of \code{n}, the number of simulations from the model per
MCMC iteration for estimating the synthetic likelihood.}

\item{\code{lambda}}{A list, with each entry containing the vector of penalty values
for the corresponding choice of \code{n}.}

\item{\code{M}}{The number of repeats used in estimating the standard deviation of
the estimated log synthetic likelihood.}

\item{\code{sigma}}{The standard deviation of the log synthetic likelihood estimator
to aim for, usually a value between 1 and 2. This reflects the mixing of a
Markov chain.}

\item{\code{model}}{A ``MODEL'' object generated with function \code{newModel}.
See \code{\link{newModel}}.}

\item{\code{stdLoglike}}{A list contains the estimated standard deviations of
log-likelihoods.}

\item{\code{penalty}}{The vector stores the selected penalty values for each given
\code{n} by choosing from the candidate \code{lambda} list. The selected
values produce closest standard deviations \code{stdLoglike} to the target
\code{sigma}.}

\item{\code{result}}{The result data frame.}

\item{\code{call}}{The original code used to run \code{\link{selectPenalty}}.}
}}

\seealso{
\code{\link{selectPenalty}} for the function that selects the
  penalty parameter.
}
\Rdversion{1.1}
