% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Spouse}
\alias{Spouse}
\title{Convictions in spouse murder cases by gender}
\format{
A data frame/tibble with 540 observations on two variables
\describe{ 
\item{result}{a factor with levels \code{not prosecuted}, \code{pleaded guilty}, 
\code{convicted}, and \code{acquited}}
\item{spouse}{a factor with levels \code{husband} and \code{wife}} 
}
}
\source{
Bureau of Justice Statistics (September 1995), \emph{Spouse Murder Defendants in Large
Urban Counties}, Executive Summary, NCJ-156831.
}
\usage{
Spouse
}
\description{
Data for Exercise 8.33
}
\examples{

T1 <- xtabs(~result + spouse, data = Spouse)
T1
chisq.test(T1)
rm(T1)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
