% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Hurrican}
\alias{Hurrican}
\title{Number of storms, hurricanes and El Nino effects from 1950 through 1995}
\format{
A data frame/tibble with 46 observations on four variables
\describe{ 
\item{year}{a numeric vector indicating year} 
\item{storms}{a numeric vector recording number of storms} 
\item{hurrican}{a numeric vector recording number of hurricanes}
\item{elnino}{a factor with levels \code{cold}, \code{neutral}, and
\code{warm}} 
}
}
\source{
National Hurricane Center.
}
\usage{
Hurrican
}
\description{
Data for Exercises 1.38, 10.19, and Example 1.6
}
\examples{

T1 <- xtabs(~hurrican, data = Hurrican)
T1
barplot(T1, col = "blue", main = "Problem 1.38",
        xlab = "Number of hurricanes", 
        ylab = "Number of seasons")
boxplot(storms ~ elnino, data = Hurrican, 
        col = c("blue", "yellow", "red"))
anova(lm(storms ~ elnino, data = Hurrican))
rm(T1)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
