% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Tonsils}
\alias{Tonsils}
\title{Size of tonsils collected from 1,398 children}
\format{A data frame/tibble with 1,398 observations on two variables
\describe{ 
\item{size}{a factor with levels \code{Normal}, \code{Large}, and \code{Very Large}} 
\item{status}{a factor with levels \code{Carrier} and \code{Non-carrier}}
}}
\usage{
Tonsils
}
\description{
Data for Exercise 2.78
}
\examples{

T1 <- xtabs(~size + status, data = Tonsils)
T1
prop.table(T1, 1)
prop.table(T1, 1)[2, 1]
barplot(t(T1), legend = TRUE, beside = TRUE, col = c("red", "green"))
\dontrun{
library(dplyr)
library(ggplot2)
NDF <- dplyr::count(Tonsils, size, status) 
ggplot2::ggplot(data = NDF, aes(x = size, y = n, fill = status)) + 
           geom_bar(stat = "identity", position = "dodge") + 
           scale_fill_manual(values = c("red", "green")) + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
