% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boss.R
\name{predict.boss}
\alias{predict.boss}
\title{Prediction given new data entries.}
\usage{
\method{predict}{boss}(object, newx, ...)
}
\arguments{
\item{object}{The boss object, returned from calling 'boss' function.}

\item{newx}{A new data entry or several entries. It can be a vector, or a matrix with
\code{nrow(newx)} being the number of new entries and \code{ncol(newx)=p} being the
number of predictors. The function takes care of the intercept, NO need to add \code{1}
to \code{newx}.}

\item{...}{Extra arguments to be plugged into \code{coef}, such as \code{select.boss},
see the description of \code{coef.boss} for more details.}
}
\value{
The prediction(s) for BOSS.
}
\description{
This function returns the prediction(s) given new observation(s), for BOSS,
where the optimal coefficient vector is chosen via certain selection rule.
}
\details{
The function basically calculates \eqn{x * coef}, where \code{coef}
is a coefficient vector chosen by a selection rule. See more details about the default
and available choices of the selection rule in the description of \code{coef.boss}.
}
\examples{
## Generate a trivial dataset, X has mean 0 and norm 1, y has mean 0
set.seed(11)
n = 20
p = 5
x = matrix(rnorm(n*p), nrow=n, ncol=p)
x = scale(x, center = colMeans(x))
x = scale(x, scale = sqrt(colSums(x^2)))
beta = c(1, 1, 0, 0, 0)
y = x\%*\%beta + scale(rnorm(n, sd=0.01), center = TRUE, scale = FALSE)

## Fit the model
boss_result = boss(x, y)

## Get the coefficient vector selected by AICc-hdf (S3 method for boss)
beta_boss_aicc = coef(boss_result)
# the above is equivalent to the following
beta_boss_aicc = boss_result$beta_boss[, which.min(boss_result$IC_boss$aicc), drop=FALSE]
## Get the fitted values of BOSS-AICc-hdf (S3 method for boss)
mu_boss_aicc = predict(boss_result, newx=x)
# the above is equivalent to the following
mu_boss_aicc = cbind(1,x) \%*\% beta_boss_aicc

## Repeat the above process, but using Cp-hdf instead of AICc-hdf
## coefficient vector
beta_boss_cp = coef(boss_result, method.boss='cp')
beta_boss_cp = boss_result$beta_boss[, which.min(boss_result$IC_boss$cp), drop=FALSE]
## fitted values of BOSS-Cp-hdf
mu_boss_cp = predict(boss_result, newx=x, method.boss='cp')
mu_boss_cp = cbind(1,x) \%*\% beta_boss_cp
}
