\name{plot.mvrm}
\alias{plot.mvrm}

\title{Creates plots of terms in the mean and/or variance models}

\description{
This function plots estimated terms that appear in the mean and variance models. 
}

\usage{
\method{plot}{mvrm}(x,model,term,response,intercept=TRUE,grid=30,centre=mean,
quantiles=c(0.1, 0.9),contour=TRUE,static=TRUE,centreEffects=FALSE,plotOptions=list(), 
nrow,ask=FALSE, ...)
}

\arguments{
\item{x}{an object of class `mvrm' as generated by function \code{mvrm}.}
\item{model}{one of "mean", "stdev", or "both", specifying which model to be visualized.}
\item{term}{the term in the selected model to be plotted.}
\item{response}{integer number denoting the response variable to be plotted (in case there is more than one).}
\item{intercept}{specifies if an intercept should be included in the calculations.}
\item{grid}{the length of the grid on which the term will be evaluated.}
\item{centre}{a description of how the centre of the posterior should be measured. Usually \code{mean} or \code{median}.}

\item{quantiles}{the quantiles to be used when plotting credible regions. 
Plots without credible intervals may be obtained by setting this argument to NULL.}

\item{contour}{relevant for 3D plots only. If \code{contour=TRUE} then \code{plot.mvrm} creates contour plots. 
\code{contour=FALSE} is allowed only for creating one plot at a time. The plot can be static or dynamic. See argument `static'.}

\item{static}{relevant for 3D plots only. If \code{static=TRUE} then \code{plot.mvrm} calls 
function \code{ribbon3D} from package \code{plot3D} to create the plot. 
If \code{static=FALSE} then \code{plot.mvrm} calls 
function \code{scatterplot3js} from package \code{threejs} to create the plot.}


\item{centreEffects}{if TRUE then the effects in the mean functions are centred around zero over the range of the 
predictor while the effects in the variance function are scaled around one.}
\item{plotOptions}{for plots of univariate smooth terms or for plots of bivariate smooth terms where one of the 
two covariates is discrete, this is a list of plot elements to give to \code{ggplot}.
For smooths of bivariate continuous covariates, this is a list of plot elements to give to 
\code{ribbon3D} (if \code{static=FALSE}) or to \code{scatterplot3js} (if \code{static=TRUE}).}
\item{nrow}{the number of rows in the figure with the plots.}
\item{ask}{if set to TRUE, plots will be displayed one at a time.}
\item{...}{other arguments.}
}

\details{Use this function to obtain predictions.}

\value{Predictions along with credible/pediction intervals}

\author{Georgios Papageorgiou \email{gpapageo@gmail.com}}

\examples{#see \code{mvrm} example}

\seealso{\code{\link{mvrm}}}
