% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_number_of_clusters_stable_process.R
\name{expected_number_of_components_Dirichlet}
\alias{expected_number_of_components_Dirichlet}
\title{Computes the expected number of components for a Dirichlet process.}
\usage{
expected_number_of_components_Dirichlet(n, Alpha, ntrunc = NULL)
}
\arguments{
\item{n}{Number of data points}

\item{Alpha}{Numeric constant. Total mass of the centering measure.}

\item{ntrunc}{Level of truncation when computing the expectation. Defaults to n. If greater than n, it is fixed to n.}
}
\value{
A real value which approximates the expected number of components

Reference: P. De Blasi, S. Favaro, A. Lijoi, R. H. Mena, I. Prünster, and M. Ruggiero, “Are gibbs-type priors the most natural generalization of the dirichlet process?,” IEEE Trans. Pattern Anal. Mach. Intell., vol. 37, no. 2, pp. 212–229, 2015.
}
\description{
Computes the expected number of components for a Dirichlet process.
}
\examples{
expected_number_of_components_Dirichlet(100, 1.2)
}
