% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_fun_dkp.R
\name{loss_fun_dkp}
\alias{loss_fun_dkp}
\title{Loss Function for Fitting the DKP Model}
\usage{
loss_fun_dkp(
  gamma,
  Xnorm,
  Y,
  prior = c("noninformative", "fixed", "adaptive"),
  r0 = 2,
  p0 = NULL,
  loss = c("brier", "log_loss"),
  kernel = c("gaussian", "matern52", "matern32")
)
}
\arguments{
\item{gamma}{A numeric vector of log-transformed kernel hyperparameters.}

\item{Xnorm}{A numeric matrix of normalized inputs (each column scaled to
\code{[0,1]}).}

\item{Y}{Matrix of observed multinomial counts, with dimension \eqn{n \times
q}.}

\item{prior}{Type of prior to use. One of \code{"noninformative"},
\code{"fixed"}, or \code{"adaptive"}.}

\item{r0}{Global prior precision (only used when \code{prior = "fixed"} or
\code{"adaptive"}).}

\item{p0}{Global prior mean vector (only used when \code{prior = "fixed"}).
Must be of length \eqn{q}.}

\item{loss}{Loss function for kernel hyperparameter tuning. One of
\code{"brier"} (default) or \code{"log_loss"}.}

\item{kernel}{Kernel function for local weighting. Choose from
\code{"gaussian"}, \code{"matern52"}, or \code{"matern32"}.}
}
\value{
A single numeric value representing the total loss (to be minimized).
}
\description{
Computes the loss used to fit the DKP model. Supports the Brier
score (mean squared error) and negative log-loss (cross-entropy), under
different prior specifications.
}
\examples{
set.seed(123)
n = 10
Xnorm = matrix(runif(2 * n), ncol = 2)
m = rep(10, n)
y = rbinom(n, size = m, prob = runif(n))
Y = cbind(y, m-y)
loss_fun_dkp(gamma = rep(0, 2), Xnorm = Xnorm, Y = Y)
}
\seealso{
\code{\link{loss_fun}}, \code{\link{fit.DKP}}, \code{\link{get_prior_dkp}},
\code{\link{kernel_matrix}}
}
