% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGrid.r
\name{makeDggrid}
\alias{makeDggrid}
\title{Make a discrete global grid}
\usage{
makeDggrid(
  polygon,
  gridSize,
  buffer = FALSE,
  topology = "hexagon",
  aperture = 3,
  simplify = FALSE,
  tol = 0.01
)
}
\arguments{
\item{polygon}{an object of class \sQuote{SpatialPolygon} or
\sQuote{SpatialPolygonDataFrame}}

\item{gridSize}{width of the cells in Km. It defines the central assumption
of this package that is the maximum area a person can explore during a day.
Be aware, that the spatial extent of a visit is dependent on the taxonomic group, and many other variables.
Maximum recomended for this package 10 km if there is no reliable definition
for the spatial extent for visits.}

\item{buffer}{shall the grid cells include the polygon border? Then \code{TRUE}
(default = \code{FALSE}).}

\item{topology}{Shape of cell. shall the grid cells be hexagonal, diamonds or
triangular? Options are: \dQuote{hexagon}, \dQuote{diamond}, \dQuote{tirangle}.
Default: \dQuote{hexagon}.}

\item{aperture}{How finely subsequent resolution levels divide the grid. Options are: 3, 4.
Only applicable for \code{topology = "hexagon"}. Default for \code{topology = "hexagon"} is 3,
else \code{aperture = 4}.}

\item{simplify}{simplifies the polygon geometry using the Douglas-Peuker algorithm  (from rgeos package).
Complicated polygons (those with much detail) make this function run slower.}

\item{tol}{numerical tolerance value for the simplification algorith. Set to 0.01 as default.}
}
\value{
an object of class \sQuote{SpatialPolygon} with a set of polygons
conforming to a grid of equal-area cells, with geodesic coordinates in WGS84 (ESPG:4326).
}
\description{
Construct a discrete global grid system (dggs) object over a preferred polygon.
}
\details{
This function depends on a package that is no longer on CRAN. You can
find it in its GitHub repository \url{https://github.com/r-barnes/dggridR}.
Also, this may generate odd results for very large rectangles, because putting
rectangles on spheres is weird... as you should know, if you're using this package.
 Use the function \code{exploreVisits()} to assess if your definition of visit
 aligns with your grid size.
}
\note{
Depending on the total number of grid cells the computations may take time.
If there are more than 100 cells on any dimension a warning message will be displayed.
Grid cells must be smaller than the sampling area. If the grid cell size is wider than the polygon on any dimension
an error message will be displayed.
}
\examples{
\donttest{
library(dggridR) ## Not anylonger on CRAN
grid <- makeDggrid(gotaland, gridSize = 10)}
}
\seealso{
\code{\link{drawPolygon}}, \code{\link{renameGrid}}, \code{\link{OB2Polygon}}, \code{\link{exploreVisits}}
}
